<?php

namespace app\api\controller;

use think\Request;
use app\api\validate\ArticleValidate;
use app\BaseController;
use app\model\ArticleModel;

class Article extends BaseController
{

    //文章列表
    public function getArticleList(Request $request)
    {

        $vo = (new ArticleValidate())->goCheck(['cate_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['cate_id' => $parm['cate_id'], 'is_del' => 0];
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = ArticleModel::where($where)
            ->field('id,title,description,sort,click,createtime,thumb,cate_id')
            ->order('createtime desc')
            ->append(['thumbpath'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);

    }

    //文章详情
    public function getArticleDetail(Request $request){

        $vo = (new ArticleValidate())->goCheck(['article_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = ArticleModel::find($parm['article_id'])->append(['thumbpath']);
        ArticleModel::where('id', $parm['article_id'])->inc('click')->update([]);
        return $this->returnMsg('success', 1, $info);
    }


}