<?php

namespace app\api\controller;

use app\api\middleware\Auth;
use app\api\service\UserService;
use app\BaseController;
use think\facade\Request;
use app\api\service\CourseProgressService;

class CourseProgress extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];



    /**
     * 上报学习进度API
     */
    public function reportProgress()
    {
        $data = Request::only(['course_id', 'class_id', 'current_time']);
        $token = Request::header('token');

        $userId = UserService::getUserInfo($token)['id'];

        $result = CourseProgressService::updateProgress(
            $userId,
            $data['course_id'],
            $data['class_id'],
            $data['current_time'],
        );

        if (!$result) {
            return $this->returnMsg('视频不存在',0);
        }

        return $this->returnMsg('操作成功',1,$result);

    }

    /**
     * 获取课程进度API
     */
    public function getProgress()
    {
        $token = Request::header('token');

        $userId = UserService::getUserInfo($token)['id'];
        $data = Request::only(['course_id','page','pageSize']);

        $progress = CourseProgressService::getUserAllCoursesProgress($userId, $data['page'], $data['pageSize']);

        return $this->returnMsg('操作成功',1,$progress);

    }

    /**
     * 获取最后学习位置API
     */
    public function getLastLearn()
    {
        $token = Request::header('token');

        $userId = UserService::getUserInfo($token)['id'];
        $data = Request::only(['course_id']);
        $lastLearn = CourseProgressService::getLearnedClasses($userId, $data['course_id']);

        return $this->returnMsg('操作成功',1,$lastLearn);

    }
}