<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\order;

use app\admin\controller\AdminBase;
use think\App;
use think\facade\Db;
use app\model\Payment as PaymentModel;


/**
 * 后台主控制器
 */
class Payment extends AdminBase
{

    protected $payment;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->payment = new PaymentModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['order_no', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['user']) && !empty($post['user'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
            }
            if (isset($post['pay_status']) && $post['pay_status'] > -1) {
                $map[] = ['pay_status', '=', $post['pay_status']];
            }
            $list = $this->payment->where($map)->hasWhere('getuserdata', $hasmap)->with(['getuserdata'])->append(['pay_status_text', 'pay_method_text', 'pay_time_text', 'order_name'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->payment->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->payment->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }



}