<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\validate\ShCourseClassValidate;
use app\BaseController;
use app\Request;
use app\model\ShCourseClass as ShCourseClassModel;
use app\model\ShCourse;

class ShCourseClass extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //添加课时
    public function createCourseClass(Request $request)
    {
        $vo = (new ShCourseClassValidate())->goCheck(['cate_id', 'course_id', 'title', 'tv_file', 'tvtime']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $parm['createtime'] = time();
        $parm['user_id'] = $request->userId;
        $result = ShCourseClassModel::create($parm);
        ShCourse::where('id', $parm['course_id'])->update(['status' => 0]); //待提交
        return $this->returnMsg('操作成功', 1, $result);
    }

    //编辑课时
    public function editCourseClass(Request $request)
    {
        $filed = ['cate_id', 'course_id', 'title', 'tv_file', 'tvtime', 'course_class_id','is_sk'];
        $vo = (new ShCourseClassValidate())->goCheck($filed);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $updatedata = $request->only($filed);;
        unset($updatedata['course_class_id']);
        $result = ShCourseClassModel::where(['user_id' => $request->userId, 'id' => $parm['course_class_id']])->update($updatedata);
        ShCourse::where('id', $parm['course_id'])->update(['status' => 0]); //待提交
        return $this->returnMsg('操作成功', 1, $result);
    }

    //删除课时
    public function deleteCourseClass(Request $request)
    {

        $vo = (new ShCourseClassValidate())->goCheck(['course_class_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['course_class_id'], 'user_id' => $request->userId];
        $result = ShCourseClassModel::where($where)->update(['is_del' => 1]);
        $course_id = ShCourseClassModel::where(['id' => $parm['course_class_id']])->value('course_id');
        event('Course', ['course_id' => $course_id, 'tasktype' => 'course', 'action' => 'shcourseupdate']); //同步数据
        return $this->returnMsg('操作成功', 1, $result);
    }

    //课时列表
    public function CourseClassList(Request $request)
    {
        $parm = $request->param();
        $map = [];
        if (isset($parm['searchkey']) && $parm['searchkey']) {
            $map[] = ['title', 'like', '%' . $parm['searchkey'] . '%'];
        }
        if (isset($parm['is_sell']) && $parm['is_sell']) {
            $map[] = ['is_sell', '=', $parm['is_sell']];
        }
        if(isset($parm['cate_id']) && $parm['cate_id']){
            $map[] = ['cate_id', '=', $parm['cate_id']];
        }

        if(isset($parm['course_id']) && $parm['course_id']){
            $map[] = ['course_id', '=', $parm['course_id']];
        }
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $where = ['is_del' => 0, 'user_id' => $request->userId];

        $list = ShCourseClassModel::where($where)->where($map)
            ->order('createtime desc')
            ->append(['course_class_cate','course_title'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);
    }

    //修改课程属性
    public function updatecourseclassinfo(Request $request)
    {
        $vo = (new ShCourseClassValidate())->goCheck(['course_class_id', 'updateField', 'updateValue']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['course_class_id'], 'user_id' => $request->userId];
        $result = ShCourseClassModel::where($where)->update([$parm['updateField'] => $parm['updateValue']]);

        $course_id = ShCourseClassModel::where(['id' => $parm['course_class_id']])->value('course_id');
        event('Course', ['course_id' => $course_id, 'tasktype' => 'course', 'action' => 'shcourseupdate']); //同步数据
        return $this->returnMsg('操作成功', 1, $result);

    }

    //课时详情

    public function ShCourseDetail(Request $request)
    {
        $vo = (new ShCourseClassValidate())->goCheck(['course_class_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = ShCourseClassModel::find($parm['course_class_id'])->append(['tvfile', 'course_class_cate','course_title']);
        return $this->returnMsg('操作成功', 1, $info);

    }

}