<?php

namespace app\model\project;

use app\model\system\SystemUploadFile;
use think\Model;

class School extends Model
{
    protected $name = 'school';

    protected $autoWriteTimestamp = true;

    protected $createTime = 'create_time';

    /**
     * 学校资质文件列表
     */
    public function getSchoolQualificationListAttr()
    {
        if (empty($this->school_qualification_url_id)) {
            return [];
        }
        return get_upload_file($this->school_qualification_url_id, 'list');
    }

    /**
     * 导师资质文件列表
     */
    public function getTeacherQualificationListAttr()
    {
        if (empty($this->teacher_qualification_url_id)) {
            return [];
        }
        return get_upload_file($this->teacher_qualification_url_id, 'list');
    }

    /**
     * 合作协议文件列表
     */
    public function getAgreementListAttr()
    {
        if (empty($this->agreement_url_id)) {
            return [];
        }
        return get_upload_file($this->agreement_url_id, 'list');
    }

    /**
     * 补充材料文件列表
     */
    public function getMoreFileListAttr()
    {
        if (empty($this->more_url_id)) {
            return [];
        }
        return get_upload_file($this->more_url_id, 'list');
    }

    //学校资质id
    public function schoolQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'school_qualification_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }

    //导师资质
    public function teacherQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'teacher_qualification_url_id')
            ->where('isdel', 0)
            ->field('fileid, filename, filesize, fileurl, filetype,fileext,storage');
    }

    //合作协议
    public function agreement()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'agreement_url_id')
            ->where('isdel', 0)
            ->field('fileid, filename, filesize, fileurl, filetype,fileext,storage');
    }

    //补充材料
    public function moreFile()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'more_url_id')
            ->where('isdel', 0)
            ->field('fileid, filename, filesize, fileurl, filetype,fileext,storage');
    }

    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    //详细地址
    public function getAddressxxAttr($value, $data)
    {
        return $data['province'].'-'.$data['city'].'-'.$data['area'];
    }

    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '审核成功';
                break;
            case 2:
                $statustxt = '审核失败';
                break;
            default:
                $statustxt = '待审核';
        }

        return $statustxt;
    }

}