<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller;


use app\model\ArticleCategoryModel;
use think\App;
use think\facade\Db;
use app\model\ArticleModel;
use app\admin\validate\ArticleValidate;

/**
 * 后台主控制器
 */
class Article extends AdminBase
{

    protected $article;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->article = new ArticleModel();

    }

    //文章列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }
            $list = $this->article->where($map)->append(['cate_name', 'adminname'])->paginate($post['limit']);

            return $this->returnMsg($list);
        }
        $category = ArticleCategoryModel::field('*,pid as parentid')->order('sort desc')->select()->toArray();
        $this->assign('category', json_encode($category));
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $this->article->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        return $this->returnMsg('修改成功');
    }

    //编辑新增文章
    public function edit()
    {
        $post = input();
        if ($this->request->isPost()) {

            $check = (new ArticleValidate())->goCheck();
            if ($check !== true) {
                return $check;
            }

            try {
                $post['admin_id'] = session(VT_MANAGER)['userid'];
                $post['createtime'] = time();
                $post['updatetime'] = time();
                if ($post['id'] > 0) {
                    $msg = '更新成功';
                    $this->article->update($post, ['id' => $post['id']]);
                } else {
                    unset($post['id']);
                    $msg = '添加成功';
                    $this->article->save($post);
                }
            } catch (\Exception $e) {

                return $this->returnMsg($e->getMessage(), 0);
            }

            return $this->returnMsg($msg, 1);

        }

        $data = $this->article->find($post['id']);
        $catemodel = new ArticleCategoryModel();
        $categorydata = $catemodel->catetree(isset($data['cate_id']) ? $data['cate_id'] : 0);

        $this->assign('categorydata', $categorydata);
        $this->assign('data', $data);
        return $this->fetch('', '', false);
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->article->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


}