<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2020-2022 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */
namespace addons\build;

use veitool\addons\Base;

use tool\Menus;
use think\facade\Db;

/**
 * 构建器
 */
class Build extends Base
{
    /**
     * 插件名称
     * @var string 
     */
    private $name = 'build';

    /**
     * 插件安装方法 必须要实现的
     * @return bool
     */
    public function install()
    {
        $file = str_replace('\\', '/', dirname(__FILE__)) . '/data/menus.php';
        if(is_file($file)){
            $data = include_once $file;
            Menus::create($data,1,$this->name);
        }
        //追加插件应用路由
        $this->setAddons([$this->name]);
        return true;
    }

    /**
     * 插件卸载方法 必须要实现的
     * @return bool
     */
    public function uninstall()
    {
        //删除相关菜单项
        Menus::delete($this->name);
        //剔除系统应用路由
        $this->setAddons([$this->name], false);
        return true;
    }

    /**
     * 插件升级方法、变动的数据、配置处理逻辑
     * @return bool
     */
    public function upgrade()
    {
        return true;
    }

    /**
     * 插件启用方法
     * @return bool
     */
    public function enable()
    {
        Menus::enable($this->name);
        //追加插件应用路由
        $this->setAddons([$this->name]);
        return true;
    }

    /**
     * 插件禁用方法
     * @return bool
     */
    public function disable()
    {
        Menus::disable($this->name);
        //剔除系统应用路由
        $this->setAddons([$this->name], false);
        return true;
    }

}