<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\course;

use app\admin\controller\AdminBase;
use app\admin\validate\CertTagValidate;
use app\model\CourseTag as CourseTagModel;
use think\App;
use think\facade\Db;


/**
 * 后台主控制器
 */
class CourseTag extends AdminBase
{

    protected $coursetag;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->coursetag = new CourseTagModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];

            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }

            $list = $this->coursetag->where($map)->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->coursetag->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if($result){
            return $this->returnMsg('修改成功',1);
        }else{
            return $this->returnMsg('修改成功');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->coursetag->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }



    //编辑新增
    public function edit()
    {
        $post = input();
        if ($this->request->isPost()) {

            $check = (new CertTagValidate())->goCheck();
            if ($check !== true) {
                return $check;
            }
            try {

                if ($post['id'] > 0) {
                    $msg = '更新成功';
                    $this->coursetag->update($post, ['id' => $post['id']]);
                } else {
                    $post['createtime'] = time();
                    unset($post['id']);
                    $msg = '添加成功';
                    $this->coursetag->save($post);
                }
            } catch (\Exception $e) {

                return $this->returnMsg($e->getMessage(), 0);
            }
            return $this->returnMsg($msg, 1);

        }
        $data = $this->coursetag->where('id',$post['id'])->find();

        $this->assign('data', $data);
        return $this->fetch('', '', false);
    }


}