<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\validate\CourseTagValidate;
use app\BaseController;
use app\Request;
use app\model\CourseTag as CourseTagModel;

class CourseTag extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //添加标签
    public function createCourseTag(Request $request)
    {
        $vo = (new CourseTagValidate())->goCheck();
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $parm['createtime'] = time();
        $parm['user_id'] = $request->userId;
        $result = CourseTagModel::create($parm);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //标签列表
    public function CourseTagList(Request $request)
    {
        $where = ['is_del' => 0, 'user_id' => $request->userId];
        $list = CourseTagModel::where($where)
            ->order('createtime desc')
            ->select()->toArray();
        return $this->returnMsg('success', 1, $list);
    }


}