<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\CourseUserWorkValidate;
use app\BaseController;
use app\model\CertTag;
use app\model\CourseUserWork as CourseUserWorkModel;
use app\Request;

class CourseUserWork extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //学员作业列表
    public function getCourseUserWorkList(Request $request)
    {
        $vo = (new CourseUserWorkValidate())->goCheck(['work_id']);
        if ($vo !== true) {
            return $vo;
        }

        $parm = $request->param();
        $map = [];
        $where = ['course_user_work.is_del' => 0, 'work_id' => $parm['work_id']];
        if (isset($parm['searchnickname']) && $parm['searchnickname']) {
            $map[] = ['username|mobile', 'like', '%' . $parm['searchnickname'] . '%'];
        }

        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = CourseUserWorkModel::where($where)->where('course_user_work.status', '>', 0)->hasWhere('userprofile', $map)
            ->order('createtime desc')
            ->with(['userprofile'])
            ->append(['status_text'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);
    }

    //学员作业详情
    public function getCourseUserWorkDetail(Request $request)
    {

        $vo = (new CourseUserWorkValidate())->goCheck(['user_work_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = CourseUserWorkModel::where('id', $parm['user_work_id'])
            ->with(['userprofile', 'course', 'courseWork'])
            ->append(['status_text', 'filelist'])
            ->find($parm['user_work_id']);

        return $this->returnMsg('success', 1, $info);
    }

    //学员作业考核
    public function shenheCourseUserWork(Request $request)
    {
        $vo = (new CourseUserWorkValidate())->goCheck(['user_work_id','status']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $updatedata['status'] = $parm['status'];
        $updatedata['note'] = $parm['note'];
        $result = CourseUserWorkModel::where('id', $parm['user_work_id'])->update($updatedata);
        return $this->returnMsg('success', 1, $result);
    }

}