<?php

namespace app\api\controller\mine;

use app\api\middleware\Auth;
use app\api\validate\CertValidate;
use app\BaseController;
use app\model\CertOrder;
use app\model\system\SystemUploadFile;
use think\Request;

class Cert extends BaseController
{
    protected $middleware = [
        Auth::class,
    ];

    public function getCertList(Request $request)
    {
        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $data = $request->param();

        $where = ['co.user_id' => $request->userId];

        if (!empty($data['status']) || $data['status'] == 0) {
            $where['co.status'] = (int)$data['status'];
        }

        $query = CertOrder::where($where)
//            ->append(['otherFileList'])
//            ->with(['headImg','idcardQ','idcardH'])
            ->alias('co')
            ->join('cert c', 'c.id = co.cert_id')
            ->field([
                'co.*',
                'c.title',
                'c.fzjg',
                'c.id as cert_id',
                'c.price',
                'c.sn'
            ]);

        if (!empty($data['search_str'])) {
            $searchStr = trim($data['search_str']);
            $query->where(function($q) use ($searchStr) {
                $q->where('c.title|c.sn', 'like', "%{$searchStr}%");
            });
        }

        $list = $query->paginate([
            'page' => $page,
            'list_rows' => $pageSize
        ]);

        return $this->returnMsg('success',1,$list);

    }

    public function getCertDetail(Request $request)
    {

        $vo = (new CertValidate())->goCheck(['cert_order_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();


        $item = CertOrder::where(['co.id'=>$data['cert_order_id'],'co.user_id'=>$request->userId])
            ->alias('co')
            ->join('cert c', 'c.id = co.cert_id')
            ->field([
                'co.*',
                'c.title',
                'c.fzjg',
                'c.id as cert_id',
                'c.price',
                'c.sn'
            ])
            ->append(['otherFileList'])
            ->with(['cert','headImg','idcardQ','idcardH'])
            ->find();

//        if ($item)
//        {
//            $item['otherFiles'] = SystemUploadFile::whereIn('fileid',$item->other_file_id)
//                ->where('isdel',0)
//                ->field('fileid,filename,filesize,fileurl,filetype')
//                ->select();
//        }


        return $this->returnMsg('success',1,$item);
    }
}