<?php

namespace app\model\project;

use think\Model;

class UserMoneyLog extends Model
{
    protected $autoWriteTimestamp = true;


    protected $createTime = 'createtime';

    /**
     * 获取用户金额变动排行榜
     * @param int $limit 前N名
     * @param string $timeRange 时间范围: 'all'-全部, 'month'-本月, 'week'-本周, 'day'-今天, 'three_month'-近三月
     * @param int $type 操作类型: null-全部, 0-项目结算, 1-提现, 2-后台手动增加
     * @return array
     */
    public static function getUserMoneyRanking($limit = 10, $timeRange = 'all', $type = null)
    {
        $query = self::field('user_id, SUM(money) as total_money')
            ->group('user_id')
            ->order('total_money', 'DESC')
            ->limit($limit);

        // 按时间范围筛选
        switch ($timeRange) {
            case 'month':
                $query->whereTime('createtime', 'month');
                break;
            case 'week':
                $query->whereTime('createtime', 'week');
                break;
            case 'day':
                $query->whereTime('createtime', 'today');
                break;
            case 'three_month':
                $threeMonthAgo = strtotime('-3 months');
                $query->where('createtime', '>=', $threeMonthAgo);
                break;
        }

        // 按操作类型筛选
        if (!is_null($type)) {
            $query->where('type', $type);
        }

        $ranking = $query->select()->toArray();;


        // 获取用户信息
        if (!empty($ranking)) {
            $userIds = array_column($ranking, 'user_id');
            $users = User::whereIn('id', $userIds)
                ->where('is_del', 0)
                ->column('username,realname,headico', 'id');

            foreach ($ranking as &$item) {
                $item['user_info'] = $users[$item['user_id']] ?? [];
            }
        }

        return $ranking;
    }

    /**添加用户资金报表
     * @param $user_id
     * @param $money
     * @param $front_money
     * @param $type
     * @param $content
     * @param $gl_table_id
     * @return UserMoneyLog
     */
    public static function addUserMoneyLog($user_id, $money, $front_money, $type, $content = '', $gl_table_id = 0, $money_type = 0)
    {
        $after_money = $money + $front_money;

        return self::create(['user_id' => $user_id, 'money' => $money, 'after_money' => $after_money, 'front_money' => $front_money
            , 'type' => $type, 'gl_table_id' => $gl_table_id, 'createtime' => time()
            , 'content' => $content, 'money_type' => $money_type]);

    }

    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    public function getTypeTextAttr($value, $data)
    {
        switch ($data['type']) {
            case 1:
                $text = '用户提现';
                break;
            case 2:
                $text = '后台操作';
                break;
            case 3:
                $text = '发布项目';
                break;
            default:
                $text = '项目结算';

        }

        return $text;
    }

    public function getMoneyTypeAttr($value, $data)
    {
        switch ($value) {
            case 1:
                $text = '信用分';
                break;
            default:
                $text = '余额';

        }

        return $text;
    }
}