<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\course;

use app\admin\controller\AdminBase;
use app\model\CourseComment AS CourseCommentModel;
use think\App;
/**
 * 后台主控制器
 */
class CourseComment extends AdminBase
{

    protected $coursecomment;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->coursecomment = new CourseCommentModel();

    }

    // 课程评论列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map['parent_id'] = '0';
            $hasmap=[];
            if (isset($post['kc']) && !empty($post['kc'])) {
                $hasmap[] = ['title', 'like', '%' . trim($post['kc']) . '%'];
            }
            if (isset($post['course_id']) && !empty($post['course_id'])) {
                $map[] = ['course_id', '=', $post['course_id']];
            }
            $usermap=[];
            if (isset($post['user']) && !empty($post['user'])) {
                $usermap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
            }

            $list = $this->coursecomment->where($map)->hasWhere('course', $hasmap)->hasWhere('user', $usermap)->with(['user','course'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $this->coursecomment->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        return $this->returnMsg('修改成功');
    }



    public function del()
    {
        $post = input();
//        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->coursecomment->destroy($post['id'])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }



    //查看回复列表
    public function getcomment()
    {
        $post = input();
        $info = $this->coursecomment->with(['user'=>['headico'],'replies'])->find($post['id']);
        $this->assign('info',$info);
        return $this->fetch('', '', false);
    }

}