<?php

namespace app\api\controller;

use app\api\middleware\Auth;
use app\api\service\TokenService;
use app\api\service\UtilService;
use app\model\CourseTeacher;
use app\Request;
use app\api\validate\CourseValidate;
use app\BaseController;
use app\model\Course as CourseModel;
use app\model\CourseCategory as CourseCategoryModel;

class Course extends BaseController
{

    /**获取推荐课程列表
     */

    public function getRecommendList(Request $request)
    {
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new CourseModel())->getRecommendList($data['category_id'],$page,$pageSize);

        return $this->returnMsg('success',1,$list);
    }

    /**获取热门课程列表
     */
    public function getHostList(Request $request)
    {
        $data = $request->param();

        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);

        $list = (new CourseModel())->getHostList($data['category_id'],$page,$pageSize);

        return $this->returnMsg('success',1,$list);
    }

    /**获取课程分类列表
     * @return \app\html
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseCategoryList()
    {
        $list = (new CourseCategoryModel())->getCourseCategoryList();

        return $this->returnMsg('success',1,$list);
    }

    public function getCourseCategoryChildrenList(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['pid']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $limit = 100;
        if($data['pid'] == 0){
            $limit = 10;
        }

        $list = (new CourseCategoryModel())->getCourseCategoryList($data['pid'] ?? 0,$limit);

        return $this->returnMsg('success',1,$list);
    }

    /**课程搜索
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function searchCourse(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['searchKeyWords']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0,'is_zb'=>1];
        $list = CourseModel::where($where)
            ->where('title', 'like', '%' . $data['searchKeyWords'] . '%')
            ->field('id,thumb,title,createtime,description,price,content')
            ->select();

        return $this->returnMsg('success',1,$list);

    }


    /**获取分类下的课程列表
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseList(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['category_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);
        $is_zb = $request->param('is_zb',0);

        $list = (new CourseModel())->getCourseListSecond($data['category_id'],$data['second_category_id'],$page,$pageSize,$data['searchKeyWords'] ?? null,$is_zb);

        return $this->returnMsg('success',1,$list);

    }


    /**获取课程详情
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     */

    public function getCourseDetail(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $token = $request->header('token');
        $userId = TokenService::verifyToken($token)['user_id'] ?? 0;
        $data2 = (new CourseModel())
//            ->with(['getTeacher','getSections'=>['getCourseClass'],'getCourseClass'])
            ->getCourseDetail($data['course_id'],$userId);
        CourseModel::where('id',$request->param('course_id'))->inc('click')->update([]);

        event('Course', ['course_id' => $data['course_id'], 'tasktype' => 'course', 'action' => 'courseupdateclick']); //同步数据
        return $this->returnMsg('success',1,$data2);

    }

    /**获取课程章节目录课时
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     */
    public function getCoureseClassList(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $token = $request->header('token');
        $userId = TokenService::verifyToken($token)['user_id'] ?? 0;
        $data = (new CourseModel())
            ->with([
                'getSections' => function ($query) use ($userId) {
                        $query->with(['getCourseClass' => function ($query) use ($userId) {
//                            $query->where(['is_sell'=>1,'is_del'=>0]);
                            $query->with(['fileData', 'courseProgress' => function($query) use ($userId) {
                                    $query->where('user_id', $userId);
                                }])
                                ->append(['tvtime_str'])
                                ->order('sort', 'desc');
                        }]);
                },
                'getCourseClass' => function ($query) use ($userId) {
                    //没有章节的课时查询
                    $query->where(['is_sell'=>1,'cate_id'=>0,'is_del'=>0]);
                        $query->with(['fileData', 'courseProgress' => function($query) use ($userId) {
                            $query->where('user_id', $userId);
                        }])
                        ->append(['tvtime_str'])
                        ->order('sort', 'desc');
                }
            ])
            ->where('id', $data['course_id'])
            ->field('id, thumb, title, createtime, description, price, content, teacher_id, tvclick, click')
            ->find();

        return $this->returnMsg('success',1,$data);
    }





}