<?php

namespace app\api\validate;

use think\Validate;

class UserValidate extends BaseValidate
{
    protected $rule =   [
        'name'  => 'require',
        'mobile'   => 'require|mobile',
        'password'=>'require|length:6,16',
        'code'=>'require',
        'token'=>'require',
        'str'=>'require',
        'confirm_password' => 'require|checkPasswordEqual',
        'password2' => 'require|checkPasswordEqual',
        'updateField'=>'require|in:username,realname,sex,headico,description,email,qq,wechat|updateFieldchange',
        'updateValue'=>'require',
        'zfb'=>'require',
        'realname'=>'require',
        'idcard'=>'require|idCard',
        'idcard_q'=>'require',
        'idcard_h'=>'require',
        'amount'=>'require|chenckAmount',
        'txType'=>'require',
        'reset_token'=>'require',
        'role'=>'require',
        'user_id'=>'require',
        'cachekey'=>'require',
    ];

    protected $message  =   [
        'cachekey.require' => '微信登录唯一标识不能为空',
        'user_id.require' => '用户id不能为空',
        'name.require' => '名称必须',
        'mobile.require'   => '手机号不能为空',
        'mobile.mobile'  => '手机号格式不正确',
        'password.require'   => '密码必须',
        'password.length'   => '密码长度必须是6-16位',
        'code.require'   => '验证码必须',
        'token.require'   => 'token必须',
        'str.require'   => '必填项不能为空',
        'confirm_password.checkPasswordEqual' => '两次输入的密码不一致',
        'password2.checkPasswordEqual' => '两次输入的密码不一致',
        'updateField.require'   => '必填项不能为空',
        'updateField.in'   => '范围不合法',
        'updateField.updateFieldchange'   => '提交信息长度或者格式错误',
        'amount.require'   => '金额不能为空',
        'amount.chenckAmount'   => '金额不合法',
        'idcard.idCard'   => '身份证格式错误',
    ];

    protected function checkPasswordEqual($value, $rule, $data)
    {
        return $value === $data['password'];
    }

    protected function chenckAmount($value, $rule, $data)
    {
        $decimal = $rule['decimal'] ?? 2;

        if (!is_numeric($value)) {
            return false;
        }

        if ($value < 0) {
            return false;
        }

        if (strpos((string)$value, '.') !== false) {
            $decimalPart = explode('.', (string)$value)[1];
            if (strlen($decimalPart) > $decimal) {
                return false;
            }
        }


        return true;
    }

    protected function updateFieldchange($value, $rule, $data)
    {
        if($value == 'email'){
            if (!filter_var($data['updateValue'], FILTER_VALIDATE_EMAIL)) {
                return false;
            }
        }elseif($value == 'username'){
            $len = mb_strlen($data['updateValue'], 'UTF-8');
            if($len > 20){
                return false;
            }
        }elseif($value == 'realname'){
            $len = mb_strlen($data['updateValue'], 'UTF-8');
            if($len > 10){
                return false;
            }
        }elseif($value == 'description'){
            $len = mb_strlen($data['updateValue'], 'UTF-8');
            if($len > 100){
                return false;
            }
        }elseif($value == 'qq'){
            $len = mb_strlen($data['updateValue'], 'UTF-8');
            if($len > 11){
                return false;
            }
        }
        return true;
    }
}