<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\study;

use app\admin\controller\AdminBase;
use app\model\StudyInformation as StudyInformationModel;
use think\App;
use think\facade\Db;
use app\model\StudyCategory;

/**
 * 后台主控制器
 */
class StudyInformation extends AdminBase
{

    protected $studyinfomation;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->studyinfomation = new StudyInformationModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }

            if (isset($post['status']) && $post['status'] > -1) {
                $map[] = ['study_information.status', '=', $post['status']];
            }
            if (isset($post['user']) && !empty($post['user'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
            }
            $list = $this->studyinfomation->where($map)->hasWhere('getuserdata', $hasmap)->with(['studycatedata', 'getuserdata'])->append(['type_text', 'status_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $category = StudyCategory::field('*,pid as parentid')->order('sort desc')->select()->toArray();
        $this->assign('category', json_encode($category));
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->studyinfomation->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改成功');
        }
    }

    public function del()
    {
        $post = input();
//        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->studyinfomation->destroy($post['id'])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


    //详情
    public function detail()
    {
        $post = input();
        $info = $this->studyinfomation->where('id', $post['id'])->with(['studycatedata', 'getuserdata'])->find()->append(['status_text','type_text']);
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }


    //推荐
    public function tuijian()
    {
        $post = input();

        if ($this->request->isAjax()) {

            $data['is_hot'] = isset($post['is_hot']) ? $post['is_hot'] : 0;
            $data['is_tj'] = isset($post['is_tj']) ? $post['is_tj'] : 0;
            $this->studyinfomation->where('id', $post['id'])->update($data);
            return $this->returnMsg("操作成功", 1);
        }
        $info = $this->studyinfomation->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);

    }

    //审核
    public function shenhestudyinfomation()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 2; //通过
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 1; //失败
        }

        $updatedata['status'] = $shstatus;
        $updatedata['status_desc'] = $errordesc;

        $result = $this->studyinfomation->where('id', $post['id'])->update($updatedata);
        if ($result) {
            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }

}