<?php
namespace app\api\middleware;

use app\api\service\ExperienceService;
use think\facade\Db;
use think\facade\Log;

class AddExperience
{
    public function handle($request, \Closure $next)
    {

        if($request->url() != '/api/task.order/run'){
            $log = [
                'ip'         => $request->ip(),
                'method'     => $request->method(),
                'url'        => $request->url(),
                'params'     => $request->param(),
                'header'     => $request->header(),
                'time'       => date('Y-m-d H:i:s'),
            ];
            Log::channel('api_log')->write($log);
        }

        $response = $next($request);

        try {
            // 获取当前控制器和方法（格式如：user/login）
            $fullAction = strtolower($request->controller() . '/' . $request->action());

            $LonginAction = ['user/login','Wecaht/checkwxlogin','user/bindmobile'];
            if (in_array($fullAction, $LonginAction))
            {
                $fullAction = 'user/login';
            }

            // 获取经验规则
            $rule = Db::name('user_exp_rule')
                ->where('action', $fullAction)
                ->where('is_open', 1)
                ->where('delete_time', null)
                ->find();

            if (!$rule) {
                return $response;
            }

            // 只有请求成功（code=1）时才处理经验
            $responseData = json_decode($response->getContent(), true);
            if (!isset($responseData['code']) || $responseData['code'] != 1) {
                return $response;
            }

            // 特殊处理登录方法（需解析 token 获取 userId）
            if ($fullAction === 'user/login') {
                $token = $responseData['data']['token'] ?? null;
            } else {
                // 普通方法直接从 header 获取 token
                $token = $request->header('token');
            }
            if (!$token) {
                return $response;
            }

            $userId = Db::name('user')
                ->where('token', $token)
                ->where('is_del', 0)
                ->value('id');

            if ($userId) {
                ExperienceService::addExperience($userId, $rule);
            }

        } catch (\Exception $e) {
            Log::error('经验系统异常：' . $e->getMessage());
        }

        return $response;
    }

}