import json
import math
import socket
import threading
import time
from concurrent.futures.thread import ThreadPoolExecutor

import requests
from sqlalchemy import and_, func, engine
from sqlalchemy.orm import Session
from core.config.env import env, COS_PATH, COS_RERURN_PATH
from libs.db_link import LinkMysql
from libs.functions import get_now_timestamp, get_now_datetime, search, get_order, get_ip, time_str_to_timestamp
from libs.orm import QueryAllData
from libs.token_verify import get_current_user
from models.recharge import Settlement, Fitransferlog, FinanceFixLog, Account_log, Paymentlog
from models.guild import Guild, GuildSettlementLog
from models.account import Account
from models.users import V2User
from models.guild import Guild

locka = threading.Lock()


class GuildSet(object):
    def __init__(self):
        self.settlement_list = []
        self.linkmysql = LinkMysql(env.DB_3YV2)

    def dispose_guild_data(self, db, num):
        guild_list = []
        locka.acquire()
        once_res = db.query(Settlement).filter().offset(num * 10).limit(10).all()
        locka.release()
        for i in once_res:
            info_dict = i.to_dict()
            guild_list.append(info_dict)
        self.settlement_list += guild_list

    def query_guild_data(self, db):
        msg_count = db.query(func.count(Settlement.id)).scalar()
        num = math.ceil(msg_count / 10)
        # 创建线程
        ths = []
        for x in range(num):
            ths.append(threading.Thread(target=self.dispose_guild_data, args=[db, x]))
        for y in range(num):
            ths[y].start()
        for z in range(num):
            ths[z].join()
        return self.settlement_list

    # def get_guild_data(self, db: Session, param):
    #     """公会结算"""
    #     is_guild_filters = []
    #     if param.guild_id:
    #         is_guild_filters.append(Settlement.guild_id == param.guild_id)
    #     if param.status or param.status == 0:
    #         is_guild_filters.append(Settlement.status == param.status)
    #     if param.start_time:
    #         is_guild_filters.append(Settlement.create_time >= param.start_time)
    #     if param.end_time:
    #         is_guild_filters.append(Settlement.create_time <= param.end_time)
    #     # 判断有无条件
    #     try:
    #         if len(is_guild_filters) > 0:
    #             get_user_orm_sql = db.query(Settlement).filter(and_(*is_guild_filters))
    #             condition_data = db.execute(get_user_orm_sql).fetchall()
    #             guild_info = [i[0].to_dict() for i in condition_data]
    #         else:
    #             guild_info = self.query_guild_data(db)
    #     except Exception as e:
    #         return [], 0
    #     # 判断是列表还是导出接口
    #     guild_info.reverse()
    #     if guild_info:
    #         return guild_info[(int(param.page) - 1) * param.size:param.size * param.page], len(guild_info)
    #     return [], 0

    def get_guild_data(self, db, page, size, status, start_time, end_time, guild_id):
        query = []
        if start_time:
            query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            query.append(f" update_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if guild_id:
            query.append(f"guild_id={guild_id} ")
        if status:
            query.append(f"status={status} ")
        if query:
            querydata = db.query(GuildSettlementLog).filter(*query).order_by(
                GuildSettlementLog.id.desc()).offset((int(page) - 1) * size).limit(size)
        else:
            querydata = db.query(GuildSettlementLog).filter().order_by(
                GuildSettlementLog.id.desc()).offset((int(page) - 1) * size).limit(size)
        data = [QueryAllData.serialization(item, remove={'create_time', 'remark'}) for item in querydata]
        list = []
        for item in data:
            item['accounts'] = item.get("pearl") + item.get("balance")
            item['update_time']=time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(item.get("update_time")))
            list.append(item)
        count = db.query(func.count(GuildSettlementLog.id)).filter().scalar()
        return list, count

    # def update_guild_info(self, data):
    #     """公会结算修改"""
    #     id = data.get("id")
    #     guild_sql = f"SELECT count(*) FROM `guild_settlement_log` where id={id})"
    #     guild_data = self.linkmysql.query_mysql(guild_sql)
    #     if guild_data:
    #         status = 1 if data.get("status") == 0 else 2
    #         guild_sql = f"UPDATE guild_settlement_log set status={status}   where id={id}"
    #         self.linkmysql.excete_mysql(guild_sql)


def paymentset_guild_data(page, size, start_time, end_time):
    query = []
    if start_time:
        query.append(f"create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
    if end_time:
        query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
    if query != []:
        count_sql = f"SELECT count(*) FROM `payment_log` where {' and '.join(query)}"
        list_sql = f"SELECT money,cont,url,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as create_time FROM `payment_log` where {' and '.join(query)} ORDER BY id desc limit {(int(page) - 1) * size},{size} "
    else:
        count_sql = f"SELECT count(*) FROM `payment_log`"
        list_sql = f"SELECT money,cont,url,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as create_time FROM `payment_log`  ORDER BY id desc limit {(int(page) - 1) * size},{size} "
    paymentset_sql = LinkMysql(env.DB_3YV2).query_mysql(count_sql)
    total = paymentset_sql[0].get("count(*)")
    payment_list = LinkMysql(env.DB_3YV2).query_mysql(list_sql)
    list = []
    for item in range(len(payment_list)):
        payment_list[item]['url'] = COS_PATH + payment_list[item].get("url")
        items = payment_list[item]
        list.append(items)
    return list, total


def outon_account_data():
    account_sql = f"select id,name,description as remark,unique_tag,uuid from fi_account"
    account = LinkMysql(env.DB_3YV2).query_mysql(account_sql)
    return account, len(account)


def account_thead_task(data):
    account_sql = f"select name from fi_account where uuid='{data['transfer_uuid']}' limit 0,1"
    account = LinkMysql(env.DB_3YV2).query_mysql(account_sql)
    if account:
        data['transfer_name'] = account[0]['name']
    else:
        data['transfer_name'] = data.get('transfer_uuid')


def accout_list_data(**params):
    accout_filters = []

    if params.get("transfer_name"):
        fi_sql = f"select uuid from fi_account where name='{params.get('transfer_name')}'"
        u_sql = f"select uuid from v2_user where nick_name='{params.get('transfer_name')}'"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, fi_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, u_sql)
        fi_data = future1.result()
        u_data = future2.result()
        if fi_data:
            transfer_uuid = fi_data[0]['uuid']
        else:
            transfer_uuid = u_data[0]['uuid'] if u_data else ''
        accout_filters.append(f" transfer_uuid='{transfer_uuid}'")
    if params.get("dst_name"):
        accout_filters.append(f" dst_name like '%{params.get('dst_name')}%'")
    if params.get("start_time"):
        accout_filters.append(f" create_time >= {time_str_to_timestamp(params.get('start_time') + ' 00:00:00')} ")
    if params.get("end_time"):
        accout_filters.append(f" create_time <= {time_str_to_timestamp(params.get('end_time') + ' 23:59:59')} ")
    if accout_filters:
        count_sql = f"select count(id) as num from fi_transfer_log where {' and '.join(accout_filters)}"
        data_sql = f"select id,amount,dst_name,create_time,dst_uuid,transfer_uuid,remarks,operator,amount_type from fi_transfer_log where {' and '.join(accout_filters)} order by id DESC limit {(int(params.get('page')) - 1) * params.get('size')},{params.get('size')}"
    else:
        count_sql = f"select count(id) as num from fi_transfer_log"
        data_sql = f"select id,amount,dst_name,create_time,dst_uuid,transfer_uuid,remarks,operator,amount_type from fi_transfer_log order by id DESC limit {(int(params.get('page')) - 1) * params.get('size')},{params.get('size')}"
    with ThreadPoolExecutor(max_workers=2) as pool:
        future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
        future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
    total = future1.result()
    res = future2.result()
    if res:
        # 多线程
        ths = []
        for x in range(len(res)):
            ths.append(threading.Thread(target=account_thead_task, args=[res[x]]))
        for y in range(len(res)):
            ths[y].start()
        for z in range(len(res)):
            ths[z].join()
        return res, total[0]['num']
    return [], 0


def query_uuid_or_user_number(param):
    """查询uuid和user_number"""
    if param.uuid:
        if param.type == 1:  # 公会查询
            guild_sql = f"select id,guild_name,uuid from guild where uuid='{param.uuid}' limit 0,1"
            guild = LinkMysql(env.DB_3YV2).query_mysql(guild_sql)
            return {"nick_name": "(公会)" + guild[0]['guild_name'], "uuid": guild[0]['uuid'], "is_guild": 1,
                    "id": guild[0]['id']} if guild else {}
        elif param.type == 2:  # 用户查询
            user_sql = f"select user_id,nick_name,uuid from v2_user where uuid='{param.uuid}' limit 0,1"
            user = LinkMysql(env.DB_3YV2).query_mysql(user_sql)
            return {"nick_name": user[0]['nick_name'], "uuid": user[0]['uuid'], "is_guild": 0,
                    "id": user[0]['user_id']} if user else {}
        else:
            user_sql = f"select user_id,nick_name,uuid from v2_user where uuid='{param.uuid}' limit 0,1"
            guild_sql = f"select id,guild_name,uuid from guild where uuid='{param.uuid}' limit 0,1"
            with ThreadPoolExecutor(max_workers=2) as pool:
                future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, user_sql)
                future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, guild_sql)
            user = future1.result()
            guild = future2.result()
            if user:
                return {"nick_name": user[0]['nick_name'], "uuid": user[0]['uuid'], "is_guild": 0,
                        "id": user[0]['user_id']}
            elif guild:
                return {"nick_name": "(公会)" + guild[0]['guild_name'], "uuid": guild[0]['uuid'], "is_guild": 1,
                        "id": guild[0]['id']}
            else:
                return {}
    if param.user_number:
        account_sql = f"select id,name,uuid,unique_tag from fi_account where uuid='{param.uuid}' limit 0,1"
        account = LinkMysql(env.DB_3YV2).query_mysql(account_sql)
        if account:
            return {"nick_name": account[0]['name'], "user_id": account[0]['unique_tag'], "uuid": account[0]['uuid'],
                    "id": account[0]['id']}
    return {}


def account_money(uuid, amount_type):
    """查询账户余额"""
    platform_data = search({"uuid": uuid}, 'Server.UserQuery.GetUserAsset')
    if platform_data['status']:
        try:
            platform_money = platform_data['data']['result']['data']['asset_balance'][amount_type]['current_amount']
        except Exception as e:
            print(f"清算系统异常：{e}")
            platform_money = '清算系统异常'
        return platform_money
    return '清算系统异常'


def query_token(db, h_list):
    """获取请求头token"""
    token = ''
    for k, v in dict(h_list).items():
        key = k.decode('utf-8')
        if key == 'authorization':
            tokens = v.decode('utf-8')
            _, token = tokens.split(' ')
            break
    # 通过token获取用户信息
    user_info = get_current_user(db=db, token=token)
    return user_info


def transfer_trigger_task(uuid, user_id, balance, type, amount_type, remark='用户转账', money_data=[],
                          isUser=1, dst_uuid="", referNum=''):
    """转账验证"""
    request_data = {
        "ip": get_ip(),
        "uuid": uuid,
        "dst_uuid": dst_uuid,
        "reference_number": get_order(),
        "reference_type": type,
        "amount": balance,
        "timestamp": get_now_timestamp(),
        "amount_type": amount_type if amount_type else 'consumable',
        "notify_url": ""
    }
    res = search(request_data, 'Server.UserExecute.Transfer')
    try:
        if not res['data']['result']['status']:
            if 'Insufficient assets' in res['data']['result']['msg']:
                return "资产不足，无法转账"
            return res['data']['result']['msg']
    except Exception as e:
        return f"清算系统异常：{str(e)}"
    status = 2
    if res['status'] == 0:
        errmsg = json.dumps(res['data'])
        status = 3
    amount_type_id = 1 if amount_type == 'consumable' else 2
    add_sql = f"insert into all_record_table(user_id, type, status, reference_number, remark, money, is_add, money_data,create_time,amount_type) " \
              f"values({user_id}, '{type}', {status},'{get_order()}','{remark}', {float(balance) * 10 if amount_type == 'consumable' else float(balance) * 100},1,'{json.dumps(money_data)}',{get_now_timestamp()},{amount_type_id});"
    LinkMysql(env.DB_3YV2).perform_mysql(add_sql)
    return ''


def transfer_money(db: Session, param, h_list):
    """转账"""
    user_id = 0
    if param.type == 0:  # 系统转系统
        out_sql = f"select name from fi_account where uuid='{param.dst_id}' limit 0,1"
        out = LinkMysql(env.DB_3YV2).query_mysql(out_sql)
        dst_name = out[0]['name']
        amount_type = 'consumable'
    if param.type == 1:  # 系统转个人/公会
        out_sql = f"select name from fi_account where uuid='{param.dst_id}' limit 0,1"
        out = LinkMysql(env.DB_3YV2).query_mysql(out_sql)
        income_sql = f"select user_id,nick_name from v2_user where uuid='{param.transfer_id}' limit 0,1"
        income = LinkMysql(env.DB_3YV2).query_mysql(income_sql)
        # income存在用户存在，就不查公会
        if income:
            user_id = income[0]['user_id']
        dst_name = out[0]['name']
        amount_type = param.transfer_type if param.transfer_type else 'consumable'
    if param.type == 2:  # 个人/公会转系统
        out_sql = f"select nick_name from v2_user where uuid='{param.dst_id}' limit 0,1"
        out = LinkMysql(env.DB_3YV2).query_mysql(out_sql)
        if out:
            dst_name = out[0]['nick_name']
        else:
            out_guild_sql = f"select guild_name from guild where uuid='{param.transfer_id}'"
            out_guild = LinkMysql(env.DB_3YV2).query_mysql(out_guild_sql)
            dst_name = out_guild[0]['guild_name'] if out_guild else param.transfer_id
        amount_type = param.transfer_type if param.transfer_type else 'consumable'

    try:
        # 转账
        is_success = transfer_trigger_task(param.dst_id, 0, param.amount, 'platformRecharge', amount_type,
                                           f"{param.dst_id}给{param.transfer_id}转账", [], 0, param.transfer_id)
        if is_success:
            return is_success
        user = query_token(db, h_list)
        transfer_sql = f"insert into fi_transfer_log(amount, dst_name, create_time, transfer_uuid, dst_uuid, user_id, remarks, operator,operator_id, amount_type) " \
                       f"values({param.amount}, '{dst_name}', {get_now_timestamp()},'{param.transfer_id}','{param.dst_id}', {user_id if user_id else 0},'{param.remark}','{user.get('username')}',{user.get('user_id')},'{amount_type}');"
        LinkMysql(env.DB_3YV2).perform_mysql(transfer_sql)
    except Exception as e:
        return str(e)
    return {}


def create_fix_table(db: Session, param, h_list):
    """增加修复报表"""
    if param.amount_type == 'backpack':
        guild_sql = f"select count(id) as num from guild where uuid='{param.uuid}'"
        user_sql = f"select user_id,nick_name,user_number from v2_user where uuid='{param.uuid}'"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, guild_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, user_sql)
        guild_info = future1.result()
        user_info = future2.result()
        if not guild_info and not user_info:
            return 'uuid不存在'
        if guild_info:
            if guild_info[0]['num']:
                return '公会账户不能更改背包账户'

        pack_sql = f"select pack_account from v2_user_config where user_id={user_info[0]['user_id']}"
        pack_account = LinkMysql(env.DB_3YV2).query_mysql(pack_sql)
        if pack_account:
            if pack_account[0]['pack_account'] == 0:
                return '该用户不存在背包账户'
    reference_number = get_order()
    ip = socket.gethostbyname(socket.gethostname())
    if param.money > 0:
        method = 'Server.BaseExecute.Increase'
        data = {
            "ip": ip,
            "dst_uuid": param.uuid,
            "dst_amount_type": param.amount_type,
            "amount": param.money,
            "fee": 0,
            "reference_number": reference_number,
            "reference_type": "finance_admin_fix",
            "reference_info": [],
            "timestamp": get_now_timestamp()
        }
    else:
        method = 'Server.BaseExecute.Reduce'
        data = {
            "ip": ip,
            "src_uuid": param.uuid,
            "src_amount_type": param.amount_type,
            "amount": abs(param.money),
            "fee": 0,
            "reference_number": reference_number,
            "reference_type": "finance_admin_fix",
            "reference_info": [],
            "timestamp": get_now_timestamp()
        }
    clearing_res = search(data, method)
    if clearing_res['status']:
        unique_res = []
        if param.type == 0:
            acc_sql = f"select unique_tag from fi_account where uuid='{param.uuid}'"
            unique_res = LinkMysql(env.DB_3YV2).query_mysql(acc_sql)
        unique_tag = unique_res[0]['unique_tag'] if unique_res else param.uuid
        user = query_token(db, h_list)
        try:
            insert_fix_sql = f"insert into finance_fix_log(type, money, create_time, unique_tag, amount_type, remark, operator,operator_id) " \
                             f"values({param.type}, {param.money}, {get_now_timestamp()}, '{unique_tag}', '{param.amount_type}', '{param.remark}', '{user.get('username')}', {user.get('user_id')});"
            LinkMysql(env.DB_3YV2).perform_mysql(insert_fix_sql)
        except Exception as e:
            return e
        return ''
    return '财务系统出错，请稍后再试！'


def recovery_thead_task(data):
    account_sql = f"select name from fi_account where uuid='{data['uuid']}'"
    acc_data = LinkMysql(env.DB_3YV2).query_mysql(account_sql)
    if acc_data:
        data['name'] = acc_data[0]['name']
    else:
        data['name'] = data['uuid']
    data['out_money'] = float(data['out_money'])
    data['entry_money'] = float(data['entry_money'])
    data['create_time'] = str(data['create_time'])
    data['from_time'] = str(data['from_time'])


def recovery_fix_data(**params):
    recovery_list = []
    if params.get("uuid"):
        recovery_list.append(f" uuid = '{params.get('uuid')}'")
    if params.get("start_time"):
        recovery_list.append(f" create_time >= '{params.get('start_time')}'")
    if params.get("end_time"):
        recovery_list.append(f" create_time < '{params.get('end_time')}'")
    if recovery_list:
        sum_sql = f"select count(id) as num from finance_error_transverse_log where {' and '.join(recovery_list)}"
        query_sql = f"select id,cont,out_money,entry_money,uuid,type,create_time,from_time from finance_error_transverse_log where  {' and '.join(recovery_list)} order by id DESC limit {(int(params.get('page')) - 1) * params.get('size')},{params.get('size')}"
    else:
        query_sql = f"select id,cont,out_money,entry_money,uuid,type,create_time,from_time from finance_error_transverse_log order by id DESC limit {(int(params.get('page')) - 1) * params.get('size')},{params.get('size')}"
        sum_sql = f"select count(id) as num from finance_error_transverse_log"
    result = LinkMysql(env.DB_3YV2).query_mysql(query_sql)
    sum = LinkMysql(env.DB_3YV2).query_mysql(sum_sql)
    if result:
        ths = []
        for x in range(len(result)):
            ths.append(threading.Thread(target=recovery_thead_task, args=[result[x]]))
        for y in range(len(result)):
            ths[y].start()
        for z in range(len(result)):
            ths[z].join()
        return result, sum[0]['num']
    return [], 0


def create_recovery_table(param):
    """增加修复报表"""
    query_sql = f"select out_money,entry_money,befor_out_money,befor_entry_money from finance_error_transverse_log where uuid='{param.uuid}' and from_time < '{param.from_time}' and type={param.type}  ORDER BY id DESC limit 0,1"
    old_info = LinkMysql(env.DB_3YV2).query_mysql(query_sql)
    if old_info:
        befor_out_money = old_info[0]['befor_out_money'] + param.out_money
        befor_entry_money = old_info[0]['befor_entry_money'] + param.entry_money
    else:
        befor_out_money = param.out_money
        befor_entry_money = param.entry_money
    # 限制一天没事，对同一个账户修复多条
    query_today_sql = f"select id from finance_error_transverse_log where uuid='{param.uuid}' and from_time = '{param.from_time}' and type={param.type}  ORDER BY id DESC limit 0,1"
    today_info = LinkMysql(env.DB_3YV2).query_mysql(query_today_sql)
    if today_info:
        return '单个账户每天只能存在一条数据'
    try:
        add_sql = f"insert into finance_error_transverse_log(type, uuid, out_money, entry_money, cont, from_time, create_time, befor_out_money, befor_entry_money) " \
                  f"values({param.type}, '{param.uuid}', {param.out_money}, {param.entry_money}, '{param.cont}', '{param.from_time}',now(), {befor_out_money}, {befor_entry_money});"
        LinkMysql(env.DB_3YV2).perform_mysql(add_sql)
    except Exception as e:
        return e
    return False


def update_recovery_table(data):
    """修改修复报表"""
    # 查询当前数据的历史数据，看看变动了哪些
    old_sql = f"select out_money,entry_money,befor_out_money,befor_entry_money from finance_error_transverse_log where id={data.id} limit 0,1"
    old_this_info = LinkMysql(env.DB_3YV2).query_mysql(old_sql)
    if not old_this_info:
        return '修改数据不存在，请检查'
    # 获取到改变的值, 说明修改前跟修改后相差这多值
    change_out_price = data.out_money - old_this_info[0]['out_money']
    change_entry_money = data.entry_money - old_this_info[0]['entry_money']
    try:
        update_sql = f"update finance_error_transverse_log set type={data.type},out_money={data.out_money},entry_money={data.entry_money},befor_out_money=befor_out_money+{change_out_price},befor_entry_money=befor_entry_money+{change_entry_money},cont='{data.cont}' where id={data.id}"
        LinkMysql(env.DB_3YV2).perform_mysql(update_sql)
    except Exception as e:
        return e
    return ''


def transfer_query(data):
    '''
    调用
    '''
    payment_sql = f"insert into payment_log(cont,money,create_time,url,uuid) values('{data.cont}','{data.money}',{get_now_timestamp()},'{data.url}','{data.uuid}')"
    platform=LinkMysql(env.DB_3YV2).perform_mysql(payment_sql)
    params = {}
    referNum=f'platomOutMoney_{platform}'
    reference_type='Payment'

    uuid =data.uuid
    ip=get_ip()
    money=data.money * -1 if data.money < 0 else data.money
    if money > 0:
        params['src_amount_type'] = 'consumable'
        params['amount'] = money
        params['fee']=0
        params['reference_info']=[]
        params['reference_number']=referNum
        params['reference_type']=reference_type
        params['src_uuid'] = uuid
        params['ip'] =ip
        params['timestamp'] = get_now_timestamp()
    status =search(params=params, method='Server.BaseExecute.Reduce')
    return status


def GuildSettlementAdd(db, data):
    guild_data = db.query(GuildSettlementLog).filter(GuildSettlementLog.id == data.id).first()
    if guild_data:
        # 修改状态
        guild_sql = f"select * from guild where id={guild_data.guild_id} limit 0,1"
        guild_info = LinkMysql(env.DB_3YV2).query_mysql(guild_sql)
        if not guild_info:
            return 400,{"msg":"公会数据错误"}
        acc_sql = f"select * from fi_account where config_key='guildSettlement' limit 0,1"
        acc_info = LinkMysql(env.DB_3YV2).query_mysql(acc_sql)
        if not acc_info:
            return 400, {"msg": "财务平台账户数据错误"}
        if guild_data.status == 0:
            try:
                url = "http://106.55.103.148:8787/api/guild/editSettlementLog"
                json = {'id': guild_data.work_id, 'status': 2}
                res = requests.post(url=url, json=json)
                if res.status_code != 200:
                    return 400, {"msg": "业务请求失败"}
            except:
                db.query(GuildSettlementLog).filter(GuildSettlementLog.id == data.id).update(
                    {GuildSettlementLog.status: 3, GuildSettlementLog.update_time: get_now_timestamp()})
                db.commit()
                return 400, {"msg": "业务请求失败"}
            db.query(GuildSettlementLog).filter(GuildSettlementLog.id == data.id).update(
                {GuildSettlementLog.status: data.status, GuildSettlementLog.update_time: get_now_timestamp()})
            db.commit()
            first_sta = 00
            # 钻石处理
            if guild_data.balance and guild_data.balance > 0:
                balance_refer_num = f'guild_settlement_{data.id}_balance'
                is_failure = transfer_trigger_task(guild_info[0].get("uuid"), 0, float(guild_data.balance), 'guild_clear', 'consumable', balance_refer_num, [], 1, acc_info[0]['uuid'])
                if is_failure:
                    return 400, {"msg": "结算错误"}
                first_sta = 1
            # 珍珠处理
            if guild_data.pearl and guild_data.pearl > 0:
                pearl_refer_num = f'guild_settlement_{data.id}_pearl'
                is_lose = transfer_trigger_task(guild_info[0].get("uuid"), 0, float(guild_data.pearl), 'guild_clear', 'withdrawable', pearl_refer_num, [], 1, acc_info[0]['uuid'])
                if is_lose:
                    return 400, {"msg": "结算错误"}
                first_sta = 1
            else:
                db.query(GuildSettlementLog).filter(GuildSettlementLog.id == data.id).update(
                    {GuildSettlementLog.status: 3, GuildSettlementLog.update_time: get_now_timestamp()})
                db.commit()
    else:
        db_export = GuildSettlementLog(work_id=data.id, guild_id=data.guild_id, balance=data.balance,
                                       pearl=data.pearl, status=data.status, create_time=data.create_time,
                                       update_time=data.update_time, guild_name=data.guild_name,
                                       guild_per=data.guild_per, actual_money=data.actual_money,
                                       pledge_deposit_money=data.pledge_deposit_money)
        db.add(db_export)
        db.commit()
    return 200,{"msg": "操作成功"}

