""" 
环境变量配置文件 env.py 
切换环境，修改文档后面的命令 env = ...

"""

from pydantic import BaseSettings


class Env(BaseSettings):
    DEBUG: bool = True
    TESTING: bool = False
    DATABASE_URI: str = 'sqlite://:memory:'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''
    MysqlDB: dict = {
        "database": "3yakj_v2",
        "host": "106.55.103.148",
        "port": 3398,
        "pwd": "c1ea602311a369f6",
        "user": "root"
    }
    SECRET_KEY: str = "09d25e094faa6ca2556c818166b7a9563b93f7099f6f0f4caa6cf63b88e8d3e7"
    ALGORITHM: str = "HS256"
    PASSWORD: str = "fj123456"


class TestingEnv(Env):
    """测试环境配置"""
    TESTING: bool = True


class ProdEnv(Env):
    """生产环境配置"""
    DATABASE_URI: str = 'mysql://user@localhost/foo'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''


env = Env()  # 开发环境
# env = TestingEnv()      # 测试环境
# env = ProdEnv()         # 生产环境
