from sqlalchemy import Column, Integer, String, DateTime, Float
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class User(Base, SerializerMixin):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    username = Column(String(100), unique=True, index=True, comment="用户名")
    remark = Column(String(255), comment="描述")
    unique = Column(String(50), unique=True, comment="唯一标识")
    hashed_password = Column(String(50), comment="密码")
    config_key = Column(String(50))
    uuid = Column(String(50))
    role_id = Column(Integer, comment="角色id")
    google_key = Column(String(255), comment="谷歌动态码secret标识")
    remaining_sum = Column(Float, comment="账户余额")
    entry_account = Column(String(255), comment="入账类目")
    out_account = Column(String(255), comment="出账类目")
    create_time = Column(DateTime, comment="创建时间")
    update_time = Column(DateTime, comment="修改时间")

    __table_args__ = {'comment': '系统用户表'}


class Authority(Base):
    __tablename__ = "authority"

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(50), index=True, comment="权限名称")
    up_one_level = Column(Integer, index=True, comment="上级权限id")
    create_time = Column(DateTime, comment="创建时间")

    __table_args__ = {'comment': '菜单权限表'}
