import math
import threading
from concurrent.futures.thread import ThreadPoolExecutor
import openpyxl
import pandas as pd
from sqlalchemy import and_, func
from app.api.statement.guild import query_token
from starlette.responses import StreamingResponse
from sqlalchemy.orm import Session
from app.api.export import crud
from core.config.env import env
from libs.db_link import LinkMysql
from core.config.env import env
from libs.db_link import LinkMysql
from libs.functions import time_str_to_timestamp
from libs.orm import QueryAllData
from models.recharge import Recharge, UserWC, GuildWC, FinanceFixLog

locka = threading.Lock()


# 写入文件
def data_to_file(db, data, name, header):
    # 获取操作人
    user = query_token(db, header)
    params = {"source": name, "method": "data_to_file", "status": 1}
    if len(data) == 0:
        params["status"] = 3
    try:
        bk = pd.DataFrame(data)
        with pd.ExcelWriter(f'static/{name}.xlsx') as writer:
            bk.to_excel(writer, sheet_name='Sheet1', index=False)
        file = open(writer, 'rb')
        # 记录导出
        crud.create_export_data(db, params, user)
        return StreamingResponse(file, media_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    except Exception as e:
        print(e)
        params["status"] = 2
        crud.create_export_data(db, params, user)


class RechargeStatement(object):
    """充值报表"""

    def __init__(self):
        self.linkmysql = LinkMysql(env.DB_3YV2)
        self.derive_list = []

    def query_data(self, page, size):
        count_sql = f'SELECT count(*) FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1'
        count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
        sql = f'SELECT d.id as order_number,d.userid as user_id,u.user_number,u.nick_name,d.money,d.paychannel as pay_channel,d.sid,d.current,FROM_UNIXTIME(d.payment_time,"%Y-%c-%d %h:%i:%s") as payment_time,FROM_UNIXTIME(d.lastupdate,"%Y-%c-%d %h:%i:%s") as last_update FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1 ORDER BY id desc limit {page},{(size)}'
        once_res = self.linkmysql.query_mysql(sql)
        money_sql = f'SELECT sum(d.balanceadd) FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1'
        moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(d.balanceadd)")
        return count, once_res, moeny_data
    def query_data(self,page,size,order_number,user_id,sid,start_time,end_time):
        query=[]
        if start_time:
            query.append(f" lastupdate >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            query.append(f" lastupdate < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if order_number:
            query.append(f"id={order_number} ")
        if  user_id:
            query.append(f"user_id={user_id} ")
        if sid:
            query.append(f"sid='{sid}' ")
        if query==[]:
            count_sql=f"SELECT count(*) FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1"
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
            sql = f'SELECT d.id as order_number,d.userid as user_id,u.user_number,u.nick_name,d.money,d.paychannel as pay_channel,d.sid,d.current,FROM_UNIXTIME(d.payment_time,"%Y-%c-%d %h:%i:%s") as payment_time,FROM_UNIXTIME(d.lastupdate,"%Y-%c-%d %h:%i:%s") as last_update FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1  ORDER BY id desc limit {(int(page) - 1) * size},{size}'
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(d.balanceadd) FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1"
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(d.balanceadd)") if \
            self.linkmysql.query_mysql(money_sql)[0].get("sum(d.balanceadd)") != None else 0
        else:
            query = ' and '.join(query).replace('lastupdate','d.lastupdate').replace('current','d.current')
            count_sql=f"SELECT count(*) FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1 and {query}"
            count=self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
            sql =f'SELECT d.id as order_number,d.userid as user_id,u.user_number,u.nick_name,d.money,d.paychannel as pay_channel,d.sid,d.current,FROM_UNIXTIME(d.payment_time,"%Y-%c-%d %h:%i:%s") as payment_time,FROM_UNIXTIME(d.lastupdate,"%Y-%c-%d %h:%i:%s") as last_update FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1  and {query} ORDER BY id desc limit {(int(page) - 1) * size},{size}'
            once_res=self.linkmysql.query_mysql(sql)
            money_sql=f"SELECT sum(d.balanceadd) FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1 and {query}"
            moeny_data= self.linkmysql.query_mysql(money_sql)[0].get("sum(d.balanceadd)") if self.linkmysql.query_mysql(money_sql)[0].get("sum(d.balanceadd)")!=None else 0
        return count,once_res,moeny_data

    # def query_all_data(self, db):
    #
    #     msg_count = db.query(func.count(Recharge.id)).scalar()
    #     num = math.ceil(msg_count / 10)
    #     # 创建线程
    #     ths = []
    #     # 创建线程
    #     for x in range(num):
    #         ths.append(threading.Thread(target=self.check_out, args=[db, x]))
    #     # 启动线程
    #     for y in range(num):
    #         ths[y].start()
    #     # 等待子进程结束
    #     for z in range(num):
    #         ths[z].join()
    #     return self.derive_list

    # def get_statements(self, db: Session, param, sp=None):
    #     """列表"""
    #     not_null_filters = []
    #     if param.order_number:
    #         not_null_filters.append(Recharge.order_number == param.order_number)
    #     if param.user_id:
    #         not_null_filters.append(Recharge.user_id == param.user_id)
    #     if param.sid:
    #         not_null_filters.append(Recharge.sid.like(f'%{param.sid}%'))
    #     if param.pay_channel:
    #         not_null_filters.append(Recharge.pay_channel.like(f'%{param.pay_channel}%'))
    #     if param.start_time:
    #         not_null_filters.append(Recharge.current >= param.start_time)
    #     if param.end_time:
    #         not_null_filters.append(Recharge.current <= param.end_time)
    #     # 判断有无条件
    #     try:
    #         if len(not_null_filters) > 0:
    #             get_user_orm_sql = db.query(Recharge).filter(and_(*not_null_filters))
    #             condition_data = db.execute(get_user_orm_sql).fetchall()
    #             serializer_info = [i[0].to_dict() for i in condition_data]
    #             serializer_info.reverse()
    #         else:
    #             serializer_info = self.query_all_data(db)
    #     except Exception as e:
    #         print(e)
    #         return [], 0, 0 if sp else []
    #     # 判断是列表还是导出接口
    #     if sp:
    #         if serializer_info:
    #             total = len(serializer_info)
    #             df = pd.DataFrame(serializer_info)
    #             count = df['money'].apply(lambda x: x).sum()
    #             return serializer_info[(int(param.page) - 1) * param.size:param.size * param.page], total, count
    #         return [], 0, 0
    #     else:
    #         return serializer_info
    def get_statements(self,data):
        query = []
        if data.start_time:
            query.append(f" lastupdate >= {time_str_to_timestamp(data.start_time + ' 00:00:00')} ")
        if data.end_time:
            query.append(f" lastupdate < {time_str_to_timestamp(data.end_time + ' 23:59:59')} ")
        if data.order_number:
            query.append(f"id={data.order_number} ")
        elif data.user_id:
            query.append(f"user_id={data.user_id} ")
        elif data.sid:
            query.append(f"sid='{data.sid}' ")
        if query == []:
            sql = f'SELECT d.id as order_number,d.userid as user_id,u.user_number,u.nick_name,d.money,d.paychannel as pay_channel,d.sid,d.current,FROM_UNIXTIME(d.payment_time,"%Y-%c-%d %h:%i:%s") as payment_time,FROM_UNIXTIME(d.lastupdate,"%Y-%c-%d %h:%i:%s") as last_update FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1  ORDER BY id desc'
            once_res = self.linkmysql.query_mysql(sql)
        else:
            query = ' and '.join(query)
            sql = f'SELECT d.id as order_number,d.userid as user_id,u.user_number,u.nick_name,d.money,d.paychannel as pay_channel,d.sid,d.current,FROM_UNIXTIME(d.payment_time,"%Y-%c-%d %h:%i:%s") as payment_time,FROM_UNIXTIME(d.lastupdate,"%Y-%c-%d %h:%i:%s") as last_update FROM `orders` as  d   inner join v2_user  as u on  d.userid=u.user_id where status=1  and {query} ORDER BY id desc'
            once_res = self.linkmysql.query_mysql(sql)
        return once_res


class WithdrawStatement(object):
    """提现报表"""

    def __init__(self):
        self.derive_user_list = []
        self.linkmysql=LinkMysql(env.DB_3YV2)
        self.derive_guild_list = []

    def thread_to_data(self, db, num):
        user_list = []
        locka.acquire()
        once_res = db.query(UserWC).filter().offset(num * 10).limit(10).all()
        locka.release()
        for i in once_res:
            info_dict = i.to_dict()
            user_list.append(info_dict)
        self.derive_user_list += user_list

    def query_user_all_data(self, db):
        msg_count = db.query(func.count(UserWC.id)).scalar()
        num = math.ceil(msg_count / 10)
        # 创建线程
        ths = []
        for x in range(num):
            ths.append(threading.Thread(target=self.thread_to_data, args=[db, x]))
        for y in range(num):
            ths[y].start()
        for z in range(num):
            ths[z].join()
        return self.derive_user_list

    # def get_user_withdraw_cash(self, db: Session, param):
    #     """用户提现"""
    #     is_filters = []
    #     if param.name:
    #         is_filters.append(UserWC.nick_name.like(f'%{param.name}%'))
    #     if param.status or param.status == 0:
    #         is_filters.append(UserWC.status == param.status)
    #     if param.start_time:
    #         is_filters.append(UserWC.current >= param.start_time)
    #     if param.end_time:
    #         is_filters.append(UserWC.current <= param.end_time)
    #     # 判断有无条件
    #     try:
    #         if len(is_filters) > 0:
    #             get_user_orm_sql = db.query(UserWC).filter(and_(*is_filters))
    #             condition_data = db.execute(get_user_orm_sql).fetchall()
    #             user_info = [i[0].to_dict() for i in condition_data]
    #         else:
    #             user_info = self.query_user_all_data(db)
    #     except Exception as e:
    #         print(e)
    #         return [], 0, 0, 0
    #     # 判断是列表还是导出接口
    #     user_info.reverse()
    #     if user_info:
    #         total = len(user_info)
    #         df = pd.DataFrame(user_info)
    #         count = df['money'].apply(lambda x: x).sum()
    #         final_count = df['final_money'].apply(lambda x: float(x)).sum()
    #         return user_info[(int(param.page) - 1) * param.size:param.size * param.page], total, count, final_count
    #     return [], 0, 0, 0
    def get_user_withdraw_cash(self,page, size, name, status,start_time,end_time):
        query = []
        if start_time:
            query.append(f" current >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            query.append(f" update_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if name:
            query.append(f" nickname like '%{name}%' ")
        if  status:
            query.append(f"status={status} ")
        if query==[]:
            choice = 1
            count_sql = f'SELECT count(*) FROM `tixian_order` where choice=1 and  `status`=3'
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")  # 总条数
            sql = f'SELECT t.usernumber as user_number,t.status,t.id as bank_code,t.nickname as nick_name,t.truename as true_name ,t.money,t.current,t.final_money,t.idcard as id_card,t.account,t.platformServiceFee as platform_service_fee,t.thirdServiceFee as  third_service_fee FROM `tixian_order` as t where choice={choice}  ORDER BY id desc limit {(int(page) - 1) * size},{size}'
            statement_list = self.linkmysql.query_mysql(sql)  # 提现总数
            money_sql = f'SELECT sum(money) FROM `tixian_order` where choice=1'
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(money)")  # 提现金额
            final_data = f'SELECT sum(final_money) FROM `tixian_order` where choice=1'
            final_money = self.linkmysql.query_mysql(final_data)[0].get("sum(final_money)")  # 实得金额
        else:
            choice=1
            query = ' and '.join(query)
            count_sql = f'SELECT count(*) FROM `tixian_order` where choice=1 and {query}'
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")  #总条数
            sql = f'SELECT t.usernumber as user_number,t.status,t.id as bank_code,t.nickname as nick_name,t.truename as true_name ,t.money,t.current,t.final_money,t.idcard as id_card,t.account,t.platformServiceFee as platform_service_fee,t.thirdServiceFee as  third_service_fee FROM `tixian_order` as t where choice={choice} and {query} ORDER BY id desc limit {(int(page) - 1) * size},{size}'
            statement_list = self.linkmysql.query_mysql(sql)  #提现总数
            money_sql = f'SELECT sum(money) FROM `tixian_order` where choice=1  and {query}'
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(money)")   #提现金额
            final_data=f'SELECT sum(final_money) FROM `tixian_order` where choice=1 and {query}'
            final_money=self.linkmysql.query_mysql(final_data)[0].get("sum(final_money)")   # 实得金额
        return statement_list, count, moeny_data,final_money

    # def dispose_guild_to_data(self, db, num):
    #     user_list = []
    #     locka.acquire()
    #     once_res = db.query(GuildWC).filter().offset(num * 10).limit(10).all()
    #     locka.release()
    #     for i in once_res:
    #         info_dict = i.to_dict()
    #         user_list.append(info_dict)
    #     self.derive_user_list += user_list
    #
    # def query_guild_all_data(self, db):
    #     msg_count = db.query(func.count(UserWC.id)).scalar()
    #     num = math.ceil(msg_count / 10)
    #     # 创建线程
    #     ths = []
    #     for x in range(num):
    #         ths.append(threading.Thread(target=self.dispose_guild_to_data, args=[db, x]))
    #     for y in range(num):
    #         ths[y].start()
    #     for z in range(num):
    #         ths[z].join()
    #     return self.derive_user_list

    # def get_guild_withdraw_cash(self, db: Session, cond):
    #     """公会提现"""
    #     is_guild_filters = []
    #     if cond.guild_id:
    #         is_guild_filters.append(GuildWC.guild_id == cond.guild_id)
    #     if cond.status or cond.status == 0:
    #         is_guild_filters.append(GuildWC.status == cond.status)
    #     if cond.start_time:
    #         is_guild_filters.append(GuildWC.update_time >= cond.start_time)
    #     if cond.end_time:
    #         is_guild_filters.append(GuildWC.update_time <= cond.end_time)
    #     # 判断有无条件
    #     try:
    #         if len(is_guild_filters) > 0:
    #             get_user_orm_sql = db.query(GuildWC).filter(and_(*is_guild_filters))
    #             condition_data = db.execute(get_user_orm_sql).fetchall()
    #             guild_info = [i[0].to_dict() for i in condition_data]
    #         else:
    #             guild_info = self.query_guild_all_data(db)
    #     except Exception as e:
    #         print(e)
    #         return [], 0, 0, 0
    #     # 判断是列表还是导出接口
    #     guild_info.reverse()
    #     if guild_info:
    #         total = len(guild_info)
    #         df = pd.DataFrame(guild_info)
    #         count = df['money'].apply(lambda x: x).sum()
    #         final_count = df['final_money'].apply(lambda x: float(x)).sum()
    #         return guild_info[(int(cond.page) - 1) * cond.size:cond.size * cond.page], total, count, final_count
    #     return [], 0, 0, 0

    def get_guild_withdraw_cash(self,page,size,guild_id,status,start_time,end_time):
        query = []
        if start_time:
            query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            query.append(f" update_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if guild_id:
            query.append(f"guild_id={guild_id} ")
        if status:
            query.append(f"status={status} ")
        if query==[]:
            count_sql = f'SELECT count(*) FROM `guild_ti_xian`'
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")  # 总条数
            sql = f'SELECT t.guild_id,t.parent_id as merchants_id,g.guild_name,t.money,t.account,t.`status`,t.finalMoney as final_money,t.update_time,t.taxRate as platform_service_fee,t.thirdServiceFee as third_service_fee FROM `guild_ti_xian` as t inner join guild  as g on g.id=t.guild_id  ORDER BY t.id desc   limit {(int(page) - 1) * size},{size}'
            statement_list = self.linkmysql.query_mysql(sql)  # 提现总数
            money_sql = f'SELECT sum(money) FROM `guild_ti_xian`'
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(money)")  # 提现金额
            final_data = f'SELECT sum(finalMoney) FROM `guild_ti_xian`'
            final_money = self.linkmysql.query_mysql(final_data)[0].get("sum(finalMoney)")  # 实得金额
        else:
            query1 = ' and '.join(query)
            query_time=' and '.join(query).replace('create_time','t.create_time').replace('update_time','t.update_time').replace('guild_id','t.guild_id').replace('status','t.status')
            count_sql = f'SELECT count(*) FROM `guild_ti_xian` where {query1}'
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")  # 总条数
            sql = f'SELECT t.guild_id,t.parent_id as merchants_id,g.guild_name,t.money,t.account,t.`status`,t.finalMoney as final_money,t.update_time,t.taxRate as platform_service_fee,t.thirdServiceFee as third_service_fee FROM `guild_ti_xian` as t inner join guild  as g on g.id=t.guild_id where {query_time} ORDER BY t.id desc   limit {(int(page) - 1) * size},{size}'
            statement_list = self.linkmysql.query_mysql(sql)  # 提现总数
            money_sql = f'SELECT sum(money) FROM `guild_ti_xian` where {query1}'
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(money)") if self.linkmysql.query_mysql(money_sql)[0].get("sum(money)")!=None else 0 # 提现金额
            final_data = f'SELECT sum(finalMoney) FROM `guild_ti_xian` where  {query1}'
            final_money = self.linkmysql.query_mysql(final_data)[0].get("sum(finalMoney)")  # 实得金额
        return statement_list, count, moeny_data, final_money


class FinanceFix(object):

    @staticmethod
    def get_finance_fix_data(page, size, start_time, end_time):
        """财务修复"""
        finance_filters = []
        if start_time:
            finance_filters.append(f" create_time <= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            finance_filters.append(f" create_time <= {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if finance_filters:
            count_sql = f"select count(id) as num from finance_fix_log where {' and '.join(finance_filters)}"
            data_sql = f"select id,type,money,unique_tag,amount_type,operator,create_time,remark from finance_fix_log where {' and '.join(finance_filters)} order by id DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select count(id) as num from finance_fix_log"
            data_sql = f"select id,type,money,unique_tag,amount_type,operator,create_time,remark from finance_fix_log order by id DESC limit {(int(page) - 1) * size},{size}"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
        total = future1.result()
        res = future2.result()
        if res:
            result = []
            for i in res:
                if i['type'] != 0:
                    # user_sql = f"select nick_name from v2_user where uuid='{i['unique_tag']}' limit 0,1"
                    # v2_user_res = LinkMysql(env.DB_3YV2).query_mysql(user_sql)
                    # if not v2_user_res:
                    #     guild_sql = f"select guild_name as name  from guild where uuid='{i['unique_tag']}' limit 0,1"
                    #     guild_res = LinkMysql(env.DB_3YV2).query_mysql(guild_sql)
                    #     if not guild_res:
                    #         i['name'] = i['unique_tag']
                    #     i['name'] = guild_res[0]['guild_name']
                    #     continue
                    # i['name'] = v2_user_res[0]['nick_name']
                    i['name'] = i['unique_tag']
                result.append(i)
            return result, total[0]['num']
        return [], 0
