import threading
import time
from concurrent.futures.thread import ThreadPoolExecutor
from datetime import datetime
import pandas as pd
from sqlalchemy import and_, func
from sqlalchemy.orm import Session
from app.api.account import schemas
from core.config.env import env
from libs.business import TYPE_NAME
from libs.db_link import LinkMysql
from libs.functions import wrapper_out, get_now_timestamp, uuid, get_before_timestamp, time_str_to_timestamp, \
    get_yesterday_timestamp, search, get_last_month
from libs.orm import QueryAllData
from models import account as models
from models.account import AccountFinance, AccountFinanceDetails, AccountType

locka = threading.Lock()


def get_account(name):
    """查询单个账户"""
    sql = f"select id from fi_account where name='{name}'"
    return LinkMysql(env.DB_3YV2).query_mysql(sql)


def get_id_to_authority(db: Session, role_id: int):
    return db.query(models.Account).filter(models.Account.id == role_id).first()


class HDUd():
    def __init__(self):
        self.result_list = []

    def thead_task(self, i):
        if i.get("income"):
            income_list = i.get('income').split(',')
            i['income'] = [int(i) for i in income_list]
        else:
            i['income'] = []
        if i.get("output"):
            output_list = i.get('output').split(',')
            i['output'] = [int(i) for i in output_list]
        else:
            i['output'] = []
        i["remark"] = i.get("description")
        if i['unique_tag']:
            start, end = get_yesterday_timestamp()
            if i['unique_tag'] == 'guild_account':
                sql = f"select sum(initial_money) as number from v3_guild_account_statistics where create_time>={start} and create_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'anchor_account':
                sql = f"select sum(initial_money) as number from v3_user_account_statistics where date>={start} and date<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'user_account':
                sql = f"select sum(initial_money) as number from finance_data_calculation_sum where type=1 and calculation_time>={start} and calculation_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'knapsack_account':
                sql = f"select sum(initial_money) as number from finance_data_calculation_sum where type=4 and calculation_time>={start} and calculation_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            elif i['unique_tag'] == 'pledgeDeduction':
                sql = f"select sum(initial_money) as number from finance_data_calculation_sum where type=5 and calculation_time>={start} and calculation_time<{end}"
                money_res = LinkMysql(env.DB_3YV2).query_mysql(sql)
                i['consumable'] = money_res[0]['number'] if money_res and money_res[0]['number'] else 0
            else:
                platform_data = search({"uuid": i['uuid']}, 'Server.UserQuery.GetUserAsset')
                if platform_data['status']:
                    try:
                        i['consumable'] = platform_data['data']['result']['data']['asset_balance']['consumable'][
                            'current_amount']
                    except Exception as e:
                        print(e)
                        i['consumable'] = 0
        else:
            i['consumable'] = 0
        self.result_list.append(i)

    def get_account_list(self, name, page, size):
        """账户列表，查询"""
        if name:
            count_sql = f"select count(id) as num from fi_account where name like '%{name}%'"
            number = LinkMysql(env.DB_3YV2).query_mysql(count_sql)
            if number:
                count = number[0].get("num")
            else:
                count = 0
            data_sql = f"select id,name,unique_tag,uuid,config_key,beneficiary,description,create_time, income, output from fi_account where name like '%{name}%' ORDER BY id DESC LIMIT {(int(page) - 1) * size},{size}"
            query_res = LinkMysql(env.DB_3YV2).query_mysql(data_sql)
        else:
            count_sql = f"select count(id) as num from fi_account"
            number = LinkMysql(env.DB_3YV2).query_mysql(count_sql)
            if number:
                count = number[0].get("num")
            else:
                count = 0
            data_sql = f"select id,name,unique_tag,uuid,config_key,beneficiary,description,create_time, income, output from fi_account ORDER BY id DESC LIMIT {(int(page) - 1) * size},{size}"
            query_res = LinkMysql(env.DB_3YV2).query_mysql(data_sql)
        if not query_res:
            return [], 0
        # 多线程
        ths = []
        # 创建线程
        for x in range(len(query_res)):
            ths.append(threading.Thread(target=self.thead_task, args=[query_res[x]]))
        # 启动线程
        for y in range(len(query_res)):
            ths[y].start()
        # 等待全部结束,再结束
        for z in range(len(query_res)):
            ths[z].join()
        self.result_list.sort(key=lambda q: q['id'], reverse=True)
        return self.result_list, count


def get_gift_type(unique_tag):
    """礼物类型"""
    if unique_tag:
        fi_income_id = []
        fi_out_id = []
        fi_sql = f"select income,output from fi_account where unique_tag='{unique_tag}'"
        gift_sql = "select id,keyName,keyValue,type from fi_account_type"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, fi_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, gift_sql)
        account = future1.result()
        output = future2.result()
        if account[0].get('output'):
            fi_out_id = [int(i) for i in account[0].get('output').split(',')]
        if account[0].get('income'):
            fi_income_id = [int(i) for i in account[0].get('income').split(',')]
        out_list = []
        income_list = []
        for info in output:
            if info.get("type") == 1 and info.get("id") in fi_income_id:
                income_list.append(info)
            if info.get("type") == 0 and info.get("id") in fi_out_id:
                out_list.append(info)
    else:
        out_list = []
        income_list = []
        gift_sql = "select id,keyName,keyValue,type from fi_account_type"
        output = LinkMysql(env.DB_3YV2).query_mysql(gift_sql)
        for info in output:
            if info.get("type") == 1:
                income_list.append(info)
            else:
                out_list.append(info)
    return {"income": income_list, "output": out_list}


def create_account(param):
    """创建账户"""
    try:
        income = ','.join(map(str, param.income))
        output = ','.join(map(str, param.output))
        sql = f"insert into fi_account(name, unique_tag, config_key, description, uuid, income, output, create_time) " \
              f"values('{param.name}', '{param.unique_tag}', '{param.config_key}', '{param.remark}', '{uuid()}', '{income}', '{output}', {get_now_timestamp()});"
        account = LinkMysql(env.DB_3YV2).perform_mysql(sql)
    except Exception as e:
        print(e)
        if 'config_key' in str(e):
            return 'config_key重复'
        return e
    return ''


def update_account_info(old_data):
    """修改账户"""
    income = ','.join(map(str, old_data.income))
    output = ','.join(map(str, old_data.output))
    try:
        sql = f"update fi_account set name='{old_data.name}',income='{income}', output='{output}', " \
              f"description='{old_data.remark}' where id = {old_data.id}"
        LinkMysql(env.DB_3YV2).perform_mysql(sql)
    except Exception as e:
        print(e)


def get_finance_group_by(date, condition):
    """账户财务信息-分组"""
    assets_sql = f"select FROM_UNIXTIME(create_time,'%Y%m%d') as create_time,type,SUM(cast(amount as decimal(20,6)))/1000 as amount from {date} WHERE  {' and '.join(condition)}  GROUP BY FROM_UNIXTIME(create_time,'%y%m%d'),type ORDER BY FROM_UNIXTIME(create_time,'%y%m%d') DESC"
    result = LinkMysql(env.DB_HISTORY).query_mysql(assets_sql)
    return result


def get_finance_info(unique_tag, page, size, start_time, end_time, is_list=None):
    """账户财务信息"""
    finance_condition = []
    month, last_month, before_last_month = get_last_month()
    if start_time:
        finance_condition.append(f"create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
    if end_time:
        finance_condition.append(f"create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
    if unique_tag in ['guild_account', 'user_account', 'knapsack_account', 'pledgeDeduction']:
        if unique_tag == 'guild_account':
            if finance_condition:
                count_sql = f"select create_time from v3_guild_account_statistics_copy where  {' and '.join(finance_condition)} GROUP BY create_time"
                data_sql = f"select id,initial_money as balance,income,outcome,create_time from v3_guild_account_statistics_copy where  {' and '.join(finance_condition)} GROUP BY create_time order by create_time DESC limit {(int(page) - 1) * size},{size}"
            else:
                count_sql = f"select create_time from v3_guild_account_statistics_copy GROUP BY create_time"
                data_sql = f"select id,initial_money as balance,income,outcome,create_time from v3_guild_account_statistics_copy GROUP BY create_time order by create_time DESC limit {(int(page) - 1) * size},{size}"
        if unique_tag == 'user_account':
            if finance_condition:
                condition = [i.replace('create_time', 'calculation_time') for i in finance_condition]
                count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=1 and {' and '.join(condition)} GROUP BY calculation_time"
                data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=1 and {' and '.join(condition)} GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
            else:
                count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=1 GROUP BY calculation_time"
                data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=1 GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
        if unique_tag == 'knapsack_account':
            if finance_condition:
                condition = [i.replace('create_time', 'calculation_time') for i in finance_condition]
                count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=4 and {' and '.join(condition)} GROUP BY calculation_time"
                data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=4 and {' and '.join(condition)} GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
            else:
                count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=4 GROUP BY calculation_time"
                data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=4 GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
        if unique_tag == 'pledgeDeduction':
            if finance_condition:
                condition = [i.replace('create_time', 'calculation_time') for i in finance_condition]
                count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=5 and {' and '.join(condition)} GROUP BY calculation_time"
                data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=5 and {' and '.join(condition)} GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
            else:
                count_sql = f"select calculation_time from finance_data_calculation_sum_copy where type=5 GROUP BY calculation_time"
                data_sql = f"select id,initial_money as balance,income,outcome,calculation_time as create_time from finance_data_calculation_sum_copy where type=5 GROUP BY calculation_time order by calculation_time DESC limit {(int(page) - 1) * size},{size}"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
        count = future1.result()
        res = future2.result()
    else:
        total_list = []
        fi_sql = f"select uuid from fi_account where unique_tag='{unique_tag}'"
        fi_res = LinkMysql(env.DB_3YV2).query_mysql(fi_sql)
        finance_condition.append(f" uuid='{fi_res[0]['uuid']}'")
        with ThreadPoolExecutor(max_workers=3) as pool:
            future1 = pool.submit(get_finance_group_by, 'assets_log_' + month, finance_condition)
            future2 = pool.submit(get_finance_group_by, 'assets_log_' + last_month, finance_condition)
            future3 = pool.submit(get_finance_group_by, 'assets_log_' + before_last_month, finance_condition)
        month_data = future1.result()
        last_data = future2.result()
        before_last_data = future3.result()
        total_list = total_list + month_data if month_data else total_list
        total_list = total_list + last_data if last_data else total_list
        ultimately_data = total_list + before_last_data if before_last_data else total_list
        result = out_income_combine(ultimately_data)
        res = result[int(page - 1) * size: page * size]
        count = result
    # 判断是列表还是导出接口
    if is_list:
        return res, len(count)
    else:
        return res


def get_account_type(**data):
    """礼物类型配置列表"""
    condition = []
    if data.get("key_name"):
        condition.append(f" keyName like '%{data.get('key_name')}%'")
    if data.get("key_value"):
        condition.append(f" keyValue like '%{data.get('key_value')}%'")
    if data.get("type") or data.get("type") == 0:
        condition.append(f" type={data.get('type')}")
    if condition:
        total_sql = f"select count(id) as num from fi_account_type where {' and '.join(condition)}"
        gift_sql = f"select id,keyName,keyValue,type,createTime as create_time from fi_account_type where {' and '.join(condition)} limit {(int(data.get('page')) - 1) * data.get('size')},{data.get('size')}"
    else:
        total_sql = f"select count(id) as num from fi_account_type"
        gift_sql = f"select id,keyName,keyValue,type,createTime as create_time  from fi_account_type limit {(int(data.get('page')) - 1) * data.get('size')},{data.get('size')}"
    total = LinkMysql(env.DB_3YV2).query_mysql(total_sql)
    output = LinkMysql(env.DB_3YV2).query_mysql(gift_sql)
    if output:
        for i in output:
            time_array = time.localtime(i['create_time'])
            i['create_time'] = time.strftime("%Y-%m-%d %H:%M:%S", time_array)
        return output, total[0]['num']
    return [], 0


def update_account_type(db: Session, data):
    """修改账目类型"""
    try:
        db.query(AccountType).filter(AccountType.id == data.id).update({AccountType.key_name: data.key_name,
                                                                        AccountType.key_value: data.key_value,
                                                                        AccountType.type: data.type})
        db.commit()
        return True
    except Exception as e:
        print(e)
        return False


def get_account_type_value(db: Session, key, type):
    """新建类型 查询是否有重复数据"""
    return db.query(AccountType).filter(AccountType.key_value == key, AccountType.type == type).first()


def create_type(db: Session, data):
    """创建新账目类型"""
    try:
        db_type = AccountType(key_name=data.key_name, key_value=data.key_value, type=data.type,
                              create_time=datetime.now())
        db.add(db_type)
        db.commit()
        db.refresh(db_type)
    except Exception as e:
        print(e)
        return {}
    return db_type


def out_income_combine(data):
    """出入账合并"""
    record = []
    record_dict = {}
    for info in data:
        res_dict = {'create_time': info.get("create_time"), 'income': 0, 'outcome': 0}
        if info.get("create_time") not in record:
            record.append(info.get("create_time"))
            record_dict[info.get("create_time")] = res_dict
        if info.get("type") == 1:
            record_dict[info.get("create_time")]['income'] = record_dict[info.get("create_time")]['income'] + float(
                info.get("amount"))
        else:
            record_dict[info.get("create_time")]['outcome'] = record_dict[info.get("create_time")]['outcome'] + float(
                info.get("amount"))
        res_dict['balance'] = res_dict['income'] - res_dict['outcome']
    record_v_list = []
    for k, v in record_dict.items():
        v['balance'] = round(v['income'] - v['outcome'], 2)
        time_arr = time.strptime(v['create_time'], "%Y%m%d")
        v['create_time'] = int(time.mktime(time_arr))
        record_v_list.append(v)
    return record_v_list


class AccountStatistics(object):
    """账户列表，查询"""

    def __init__(self, page, size, uuid, user_id, start_time, end_time, type, gift_type, unique):
        self.page = page
        self.size = size
        self.uuid = uuid
        self.user_id = user_id
        self.start_time = start_time
        self.end_time = end_time
        self.type = type
        self.gift_type = gift_type
        self.unique = unique
        self.guild_uuid = []
        self.user_list = []

    def business_query(self, date, condition):
        """业务数据查询"""
        if self.unique in ["user_account", "guild_account", "knapsack_account"]:
            if self.user_list:
                user_uuid = self.user_list[0]
                condition.append(f" uuid='{user_uuid.get('uuid')}'")
            u_sql = f"select uuid,type,reference_type,SUM(cast(amount as decimal(20,6)))/1000 as amount,create_time,amount_type from {date} WHERE {' and '.join(condition)} GROUP BY uuid,type,reference_type,amount_type ORDER BY create_time DESC"
        else:
            if self.uuid:
                condition.append(f" uuid='{self.uuid}'")
            if condition:
                u_sql = f"select id,uuid,order_number,type,reference_type,amount/1000 as amount,create_time from {date} WHERE {' and '.join(condition)} ORDER BY create_time DESC"
            else:
                u_sql = f"select id,uuid,order_number,type,reference_type,amount/1000 as amount,create_time from {date}  ORDER BY create_time DESC"
        result = LinkMysql(env.DB_HISTORY).query_mysql(u_sql)
        return result

    def user_guild_query(self, data):

        guild_sql = f"select uuid from guild"
        system_sql = f"select uuid from fi_account"
        with ThreadPoolExecutor(max_workers=2) as pool:
            guild = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, guild_sql)
            system = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, system_sql)
        guild_list = guild.result()
        system_list = system.result()
        res_list = []
        if self.unique == 'guild_account':
            guild_uuid_list = [i.get('uuid') for i in guild_list]
            for info in data:
                if info.get('uuid') in guild_uuid_list:
                    res_list.append(info)
        if self.unique == 'knapsack_account':
            for info in data:
                if info.get('amount_type') == 'backpack':
                    res_list.append(info)
        if self.unique == 'user_account':
            guild_uuid_list = [i.get('uuid') for i in guild_list]
            system_uuid_list = [i.get('uuid') for i in system_list]
            for info in data:
                if info.get('uuid') not in guild_uuid_list and info.get('uuid') not in system_uuid_list:
                    res_list.append(info)
        return res_list

    def public_query(self):
        """公共查询条件判断"""
        public_list = []
        if self.gift_type:
            public_list.append(f" reference_type = {self.gift_type}")
        if self.type or self.type == 0:
            public_list.append(f" type={self.type}")
        if self.start_time:
            public_list.append(f" create_time >= {time_str_to_timestamp(self.start_time + ' 00:00:00')} ")
        if self.end_time:
            public_list.append(f" create_time <= {time_str_to_timestamp(self.end_time + ' 23:59:59')} ")
        if self.unique == 'knapsack_account':
            public_list.append(f" amount_type='backpack'")
        if self.unique == 'user_account':
            public_list.append(f" amount_type in('consumable','withdrawable')")
        return public_list

    def get_finance_details(self, is_list=None):
        """账户财务明细"""

        total_list = []
        yw_condition = self.public_query()
        month, last_month, before_last_month = get_last_month()
        if self.unique == "user_account":
            if self.user_id:
                user_sql = f"select uuid from v2_user where user_id={self.user_id}"
                self.user_list = LinkMysql(env.DB_3YV2).query_mysql(user_sql)
        with ThreadPoolExecutor(max_workers=3) as pool:
            future1 = pool.submit(self.business_query, 'assets_log_' + month, yw_condition)
            future2 = pool.submit(self.business_query, 'assets_log_' + last_month, yw_condition)
            future3 = pool.submit(self.business_query, 'assets_log_' + before_last_month, yw_condition)
        month_data = future1.result()
        last_data = future2.result()
        before_last_data = future3.result()
        total_list = total_list + month_data if month_data else total_list
        total_list = total_list + last_data if last_data else total_list
        ultimately_data = total_list + before_last_data if before_last_data else total_list
        if self.unique in ["user_account", "guild_account", "knapsack_account"]:
            ultimately_data = self.user_guild_query(total_list)
            record = []
            record_dict = {}
            for info in ultimately_data:
                res_dict = {'uuid': info.get("uuid"), 'create_time': info.get("create_time"), 'income': 0, 'outcome': 0}
                if info.get("uuid") not in record:
                    record.append(info.get("uuid"))
                    record_dict[info.get("uuid")] = res_dict
                if info.get("type") == 1:
                    record_dict[info.get("uuid")]['income'] = record_dict[info.get("uuid")]['income'] + float(info.get("amount"))
                else:
                    record_dict[info.get("uuid")]['outcome'] = record_dict[info.get("uuid")]['outcome'] + float(info.get("amount"))
            res_data = [v for k, v in record_dict.items()]
            return res_data[int(self.page - 1) * self.size: self.page * self.size], len(res_data), 0
        total = len(ultimately_data)
        res = ultimately_data[int(self.page - 1) * self.size: self.page * self.size]
        # 判断是列表还是导出接口
        if is_list:
            if not res:
                return [], 0, 0
            for i in res:
                i['reference_name'] = TYPE_NAME[i['reference_type']] if TYPE_NAME.get(i['reference_type']) else i[
                    'reference_type']
            data_pd = pd.DataFrame(ultimately_data)
            amount_total = data_pd['amount'].sum()
            return res, total, float(amount_total)
        else:
            return res


class SpecificAccountQuery(object):
    """账户用户，背包，公会第四层查询"""

    def __init__(self, page, size, uuid, time, type, reference_type, unique_tag):
        self.page = page
        self.size = size
        self.uuid = uuid
        self.start_time = time
        self.end_time = time
        self._type = type
        self.reference_type = reference_type
        self.unique_tag = unique_tag
        self.total_list = []

    def condition_query(self, date, cond_list):

        sql = f"select uuid,type,cast(amount as decimal(20,6))/1000 as amount,reference_type,create_time,amount_type from {date} WHERE {' and '.join(cond_list)} ORDER BY create_time DESC"
        result = LinkMysql(env.DB_HISTORY).query_mysql(sql)
        return result

    def business_logic(self):
        condition = []
        condition.append(f" uuid='{self.uuid}'")
        condition.append(f" create_time >= {time_str_to_timestamp(self.start_time + ' 00:00:00')}")
        end_time = time_str_to_timestamp(self.end_time + ' 00:00:00') + 86400  # 结束时间那天包含在内，固小于第二天凌晨
        condition.append(f" create_time < {end_time}")
        if self._type == 1 or self._type == 0:
            condition.append(f" type={self._type}")
        if self.reference_type:
            condition.append(f" reference_type='{self.reference_type}'")
        if self.unique_tag == 'knapsack_account':
            condition.append(f" amount_type='backpack'")
        if self.unique_tag == 'user_account':
            condition.append(f" amount_type in('consumable','withdrawable')")
        month, last_month, before_last_month = get_last_month()
        with ThreadPoolExecutor(max_workers=3) as pool:
            future1 = pool.submit(self.condition_query, 'assets_log_' + month, condition)
            future2 = pool.submit(self.condition_query, 'assets_log_' + last_month, condition)
            future3 = pool.submit(self.condition_query, 'assets_log_' + before_last_month, condition)
        month_data = future1.result()
        last_data = future2.result()
        before_last_data = future3.result()
        if month_data:
            self.total_list = self.total_list + month_data if month_data[0]['uuid'] else self.total_list
        if last_data:
            self.total_list = self.total_list + last_data if last_data[0]['uuid'] else self.total_list
        if before_last_data:
            self.total_list = self.total_list + before_last_data if before_last_data[0]['uuid'] else self.total_list
        total = len(self.total_list)
        res = self.total_list[int(self.page - 1) * self.size: self.page * self.size]
        if not res:
            return [], 0, 0
        for i in res:
            i['reference_name'] = TYPE_NAME[i['reference_type']] if TYPE_NAME.get(i['reference_type']) else i[
                'reference_type']
        data_pd = pd.DataFrame(self.total_list)
        amount_total = data_pd['amount'].sum()
        return res, total, float(amount_total)
