from sqlalchemy.orm import Session

from libs.functions import get_now_datetime
from libs.orm import QueryAllData
from models.margin import GuildMargin
from models.guild import Guild, GuildPledgeRecord
from models.margin import GuildMargin


def get_margin(db: Session, param):
    """保证金列表，查询"""
    guild_filters = []
    if param.get("guild_id"):
        guild_filters.append(GuildMargin.guild_id == param.get("guild_id"))
    if param.get("status"):
        guild_filters.append(GuildMargin.status == param.get("status"))
    if param.get("start_time"):
        guild_filters.append(GuildMargin.create_time >= param.get("start_time") + " 00:00:00")
    if param.get("end_time"):
        guild_filters.append(GuildMargin.create_time <= param.get("end_time") + " 23:59:59")
    querydata, count = QueryAllData(db, GuildMargin, param, guild_filters).query_data()
    data = [QueryAllData.serialization(item) for item in querydata]
    return data, count


def margin_dispose(db: Session, param):
    if param.get("examine_status") == -1:
        db.query(GuildMargin).filter(GuildMargin.id == param.get("id")).update({GuildMargin.status: 5})
        db.commit()
        return '拒绝成功'
    # 查询公会
    guid_info = db.query(Guild).filter(Guild.id == param.get("guild_id")).first()
    if not guid_info:
        return '公会不存在'
    try:
        # 修改公会保证金记录 状态
        db.query(GuildMargin).filter(GuildMargin.id == param.get("id")).update({GuildMargin.status: 4})
        db.commit()
    except Exception as e:
        print(e)
    # 给公会添加保证金
    db.query(Guild).filter(Guild.id == param.get("guild_id")).update({Guild.margin: guid_info.margin + param.get("amount")})
    # 添加保证金添加记录
    try:
        gpr = GuildPledgeRecord(guild_id=param.get("guild_id"), before_pears=guid_info.margin, after_pears=guid_info.margin + param.get("amount"),
                                create_time=get_now_datetime(), update_time=get_now_datetime(), tixian_id=0,
                                is_handle=1, pledge_pearl=0, margin=param.get("amount"))
        db.add(gpr)
        db.commit()
        db.refresh(gpr)
    except Exception as e:
        print(e)
