import decimal
import json
from fastapi import status
from fastapi.responses import Response


class HttpMessage(object):
    SUCCESS = "操作成功"
    USER_EXIST = "用户已存在"
    USER_NOT_EXIST = "用户不存在"
    LOGIN_SUCCESS = "登录成功"

    ROLE_EXIST = "角色已存在"
    NO_DELETE_ROLE = "不能删除已绑定用户的角色！"

    ACCOUNT_EXIST = "账号已存在"


class DecimalEncoder(json.JSONEncoder):
    def default(self, res):
        if isinstance(res, decimal.Decimal):
            return float(res)
        super(DecimalEncoder, self).default(res)


class HttpResultResponse(Response):
    def __init__(self, code=None, msg=None, **kwargs):
        result_dict = {
            'code': code if code else status.HTTP_200_OK,
            'msg': msg if msg else HttpMessage.SUCCESS
        }

        result_dict = {**result_dict, **kwargs}
        super().__init__(
            content=json.dumps(result_dict,cls=DecimalEncoder),
            media_type="application/json",
            status_code=result_dict.get('code')
        )
