from datetime import datetime

from sqlalchemy import and_
from sqlalchemy.orm import Session
from app.api.account import schemas
from libs.functions import wrapper_out
from models import account as models
from models.account import AccountFinance, AccountFinanceDetails


def get_account(db: Session, name: str):
    """查询单个"""
    return db.query(models.Account).filter(models.Account.name == name).first()


def get_id_to_authority(db: Session, role_id: int):
    return db.query(models.Account).filter(models.Account.id == role_id).first()


@wrapper_out()
def get_account_list(db: Session, param):
    """列表"""
    result_list = []

    if param.name:
        query_res = db.query(models.Account).filter(models.Account.name.like(f'%{param.name}%')).\
            offset((int(param.page) - 1) * param.size).limit(param.page * param.size).all()
    else:
        query_res = db.query(models.Account).offset((int(param.page) - 1) * param.size).limit(param.page * param.size).all()
    if not query_res:
        return []
    for i in query_res:
        serializer_info = i.to_dict()
        if i.income:
            income_list = serializer_info.get('income').split(',')
            serializer_info['income'] = [int(i) for i in income_list]
        else:
            serializer_info['income'] = []
        if i.output:
            output_list = serializer_info.get('output').split(',')
            serializer_info['output'] = [int(i) for i in output_list]
        else:
            serializer_info['output'] = []
        result_list.append(serializer_info)
    return result_list


def get_gift_type(db: Session):
    """礼物类型"""
    out_list = []
    income_list = []
    output = db.query(models.AccountType).all()
    for i in output:
        try:
            zer_info = i.to_dict(only=('id', 'key_name', 'key_value', 'type'))
        except:
            zer_info = i
        if zer_info.get("type") == 1:
            income_list.append(zer_info)
        else:
            out_list.append(zer_info)
    return {"income": income_list, "output": out_list}


def create_account(db: Session, param: schemas.AccountCreate):
    """创建"""
    try:
        db_account = models.Account(name=param.name, unique_tag=param.unique_tag, config_key=param.config_key,
                                    remark=param.remark, income=','.join(map(str, param.income)),
                                    output=','.join(map(str, param.output)), create_time=datetime.now())
        db.add(db_account)
        db.commit()
        db.refresh(db_account)
    except Exception as e:
        print(e)
        return {}
    return db_account


def update_account_info(db: Session, old_data):
    """修改"""
    if old_data.name:
        db.query(models.Account).filter(models.Account.id == old_data.id).update(
            {models.Account.name: old_data.name})
    if old_data.remark:
        db.query(models.Account).filter(models.Account.id == old_data.id).update(
            {models.Account.remark: old_data.remark})
    if old_data.income:
        db.query(models.Account).filter(models.Account.id == old_data.id).update(
            {models.Account.income: ','.join(map(str, old_data.income))})
    if old_data.output:
        db.query(models.Account).filter(models.Account.id == old_data.id).update(
            {models.Account.output: ','.join(map(str, old_data.output))})
    db.commit()


def get_finance_info(db, data):
    """账户财务信息"""
    finance_condition = []
    finance_condition.append(AccountFinance.account_id == data.aid)
    if data.start_time:
        finance_condition.append(AccountFinance.create_time >= data.start_time)
    if data.end_time:
        finance_condition.append(AccountFinance.create_time <= data.end_time)
    if not finance_condition:
        query_res = db.query(AccountFinance).all()
        return [i.to_dict() for i in query_res][::-1]
    else:
        get_user_orm_sql = db.query(AccountFinance).filter(and_(*finance_condition))
        query_res = db.execute(get_user_orm_sql).fetchall()
    return [i[0].to_dict() for i in query_res][::-1]


def get_finance_details(db, data):
    """账户财务明细"""
    finance_condition = []
    if data.type or data.type == 0:
        finance_condition.append(AccountFinanceDetails.type == data.type)
    if data.gift_type:
        finance_condition.append(AccountFinanceDetails.gift_type == data.gift_type)
    if data.start_time:
        finance_condition.append(AccountFinanceDetails.create_time >= data.start_time)
    if data.end_time:
        finance_condition.append(AccountFinanceDetails.create_time <= data.end_time)
    if not finance_condition:
        query_res = db.query(AccountFinanceDetails).all()
        return [i.to_dict() for i in query_res][::-1]
    else:
        get_user_orm_sql = db.query(AccountFinanceDetails).filter(and_(*finance_condition))
        query_res = db.execute(get_user_orm_sql).fetchall()
    return [i[0].to_dict() for i in query_res][::-1]
