from typing import Optional
from pydantic import BaseModel


class PublicModel(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    start_time: Optional[str] = ""
    end_time: Optional[str] = ""


class AccountCreate(BaseModel):
    name: str
    remark: Optional[str] = None
    unique_tag: str
    config_key: Optional[str] = None
    income: Optional[list] = []
    output: Optional[list] = []


class AccountList(BaseModel):
    name: Optional[str] = None
    page: Optional[int] = None
    size: Optional[int] = None


class AccountUpdate(BaseModel):
    id: int
    name: str
    remark: str
    income: list
    output: list


class FinanceInfo(PublicModel):
    aid: int


class FinanceDetails(PublicModel):
    type: Optional[int] = None
    gift_type: Optional[int] = None
