from typing import Optional
from pydantic import BaseModel


class AccountCreate(BaseModel):
    name: str
    remark: Optional[str] = None
    unique_tag: str
    config_key: Optional[str] = None
    income: Optional[list] = []
    output: Optional[list] = []


class AccountList(BaseModel):
    name: Optional[str] = None
    page: Optional[int] = None
    size: Optional[int] = None


class AccountUpdate(BaseModel):
    id: int
    name: str
    remark: str
    income: list
    output: list
