from pydantic import BaseModel
from typing import Optional
from sqlalchemy.orm import Session
from models import roles as models


class RoleCreate(BaseModel):
    role_name: str
    authority: list
    remark: str


class RoleUpdate(RoleCreate):
    id: int


class RoleList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    role_name: Optional[str] = ""
