# encoding:utf-8
'''
创建数据库连接引擎
'''

from sqlalchemy import create_engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
import os

from core.config.env import env

modul_path = os.path.dirname(os.path.abspath(__file__))  # 此模块所在的绝对路径

# 使用 sqlite 数据库
SQLALCHEMY_DATABASE_URL = f'sqlite:///{modul_path}/sql_app.db'

# 使用 mysql 数据库
# SQLALCHEMY_DATABASE_URL = f'mysql://{env.DATABASE_USER}:{env.DATABASE_PWD}@{env.DATABASE_URI}'

# connect_args={'check_same_thread': False} 仅仅在使用 sqlite数据库时有用
engine = create_engine(
    SQLALCHEMY_DATABASE_URL, encoding='utf-8', echo=True, connect_args={'check_same_thread': False}
)

# 数据库 session 类，用于创建 session 实例
# autoflush 是指发送数据库语句到数据库，但数据库不一定执行写入到磁盘
SessionLocal = sessionmaker(autocommit=False, autoflush=False, bind=engine)

# 创建 Base 类，用于 ORM 模型的继承
Base = declarative_base()
