from fastapi import HTTPException
from pydantic import BaseModel, validator
from typing import Optional


class UserBase(BaseModel):
    username: str

    @validator('username')
    def username_must_contain_space(cls, v):
        if len(v) > 50:
            raise HTTPException(status_code=500, detail="用户名太长")
        return v


class UserCreate(UserBase):
    remark: Optional[str] = ""
    role_id: int


class User(UserBase):
    id: int

    class Config:
        orm_mode = True


class UserLoginForm(BaseModel):
    username: str
    password: str
    verify: str


class GoogleCode(BaseModel):
    username: str


class GoogleLogin(BaseModel):
    username: str
    password: str
    google_key: str
    google_code: str


class PermissionCreate(BaseModel):

    id: int
    remark: str
    role_id: int


class UserList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    username: Optional[str] = ""


class UserUpdate(BaseModel):
    username: str
    old_pwd: str
    new_pwd: str
    confirm_pwd: str
