from pydantic import BaseModel
from typing import Optional


class RoleCreate(BaseModel):
    role_name: str
    authority: list
    remark: Optional[int] = None


class RoleUpdate(RoleCreate):
    id: int


class RoleList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    role_name: Optional[str] = ""
