""" 
环境变量配置文件 env.py 
切换环境，修改文档后面的命令 env = ...

"""
import os
from pydantic import BaseSettings
from starlette.middleware.cors import CORSMiddleware
from main import app

from app.api.api_v1 import api_router


class Env(BaseSettings):
    DEBUG: bool = True
    TESTING: bool = False
    DATABASE_URI: str = 'sqlite://:memory:'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''
    API_V1_STR = "/api"
    PROJECT_NAME = os.getenv("PROJECT_NAME")
    # 设置允许访问的域名
    origins = ['*']  # 可以设置为'*'，即为所有。
    # 设置跨域传参
    app.add_middleware(
        CORSMiddleware,
        allow_origins=origins,  # 设置允许的origins来源
        allow_credentials=True,
        allow_methods=['*'],  # 设置允许跨域的http方法，比如 get、post、put等。
        allow_headers=['*'])  # 允许跨域的headers，可以用来鉴别来源等作用。

    app.include_router(api_router, prefix=API_V1_STR)


class TestingEnv(Env):
    '''
    测试环境配置
    '''
    TESTING: bool = True


class ProdEnv(Env):
    '''生产环境配置'''
    DATABASE_URI: str = 'mysql://user@localhost/foo'
    DATABASE_USER: str = ''
    DATABASE_PWD: str = ''


env = Env()  # 开发环境
# env = TestingEnv()      # 测试环境
# env = ProdEnv()         # 生产环境
