from app.api.statement import crud, schemas
from fastapi import APIRouter

from app.api.statement.crud import RechargeStatement, WithdrawStatement
from libs.result_format import HttpResultResponse

router = APIRouter()


@router.post("/recharge/list")
def statement_recharge_list(data: schemas.StatementList):
    """充值报表列表"""
    statement_list, money = RechargeStatement().get_statements(data, 1)
    return HttpResultResponse(count=len(statement_list), total=money, data=statement_list)


@router.post("/derive/excel")
def statement_derive_excel(data: schemas.StatementList):
    """充值报表导出"""
    statement_list = RechargeStatement().get_statements(data)
    return crud.data_to_file(statement_list, "充值报表")


@router.post("/userWithdrawal/list")
def user_withdrawal_list(data: schemas.UserWithdrawalList):
    """用户提现列表"""
    statement_list = WithdrawStatement().get_user_withdraw_cash(data, 1)
    return HttpResultResponse(data=statement_list)


@router.post("/userWithdrawal/excel")
def user_withdrawal_excel(data: schemas.UserWithdrawalList):
    """用户提现导出"""
    user_list = WithdrawStatement().get_user_withdraw_cash(data)
    return crud.data_to_file(user_list, "用户提现")
