from sqlalchemy import Column, Integer, String, DateTime, Text
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class Menuconfig(Base, SerializerMixin):
    __tablename__ = "menuconfig"

    id = Column(Integer, primary_key=True, index=True)
    menu_name = Column(String(100), unique=True, index=True, comment="菜单类型名")
    menu_label= Column(String(100), unique=True, index=True, comment="菜单类型别名")
    menu_type = Column(Integer, comment="1是充值 2是消费  3是用户提现 4是公会提现")
    remark = Column(Text, comment="备注")
    create_time = Column(DateTime, comment="创建时间")

    __table_args__ = {'comment': '财务菜单配置表'}
