import math
import threading
import time
from concurrent.futures.thread import ThreadPoolExecutor
from datetime import datetime
import xlsxwriter
import pandas as pd
from sqlalchemy import func, and_
from app.api.statement import schemas
from app.api.statement.guild import query_token
from starlette.responses import StreamingResponse
from sqlalchemy.orm import Session
from app.api.export import crud
from core.config.env import env
from libs.db_link import LinkMysql
from libs.functions import time_str_to_timestamp, timestamp_to_time_str, get_month_last_month, get_date_list
from libs.log_utils import Logger
from libs.orm import QueryAllData
from models.recharge import Recharge, UserWC, GuildWC, FinanceFixLog
from models.menuconfig import Menuconfig
from decimal import Decimal

locka = threading.Lock()


# 写入文件
def data_to_file(db, data, name, header, field_list):
    # 获取操作人
    user = query_token(db, header)
    params = {"source": name, "method": "data_to_file", "status": 1}
    if len(data) == 0:
        params["status"] = 3
    try:
        bk = pd.DataFrame(data)
        if data[0].get('create_time'):
            if isinstance(data[0]['create_time'], int):
                bk['create_time'] = bk['create_time'].apply(
                    lambda x: time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(x)))
        bk.columns = field_list  # 修改pandas头
        with pd.ExcelWriter(f'static/{name}.xlsx') as writer:
            bk.to_excel(writer, sheet_name='Sheet1', index=False)
        file = open(writer, 'rb')
        # 记录导出
        crud.create_export_data(db, params, user)
        return StreamingResponse(file, media_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    except Exception as e:
        params["status"] = 2
        crud.create_export_data(db, params, user)


# 账户类型导出专用
def account_data_to_file(db, data, outcome, income, header):

    user = query_token(db, header)
    params = {"source": '账户类型汇总', "method": "data_to_file", "status": 1}
    if len(data) == 0:
        params["status"] = 3
    try:
        income_list = [i for i in data if i['type'] == '入账']
        outcome_list = [i for i in data if i['type'] == '出账']
        workbook = xlsxwriter.Workbook("static/账户类型汇总.xlsx")
        worksheet = workbook.add_worksheet()
        merge_format = workbook.add_format({
            'align': 'center',  # 水平居中
            'valign': 'vcenter',  # 垂直居中
            'fg_color': '#D7E4BC',  # 颜色填充
        })
        worksheet.merge_range("A1:B1", "出账", merge_format)
        worksheet.write(1, 0, '类型')
        worksheet.write(1, 1, '金额（元）')
        row = 2
        col = 0
        for x in outcome_list:
            worksheet.write(row, col, x['name'])
            worksheet.write(row, col + 1, x['money'])
            row += 1
        worksheet.write(row, 0, '合计')
        worksheet.write(row, 1, outcome)
        row += 2
        worksheet.merge_range(f"A{row}:B{row}", "入账", merge_format)
        worksheet.write(1, 0, '类型')
        worksheet.write(1, 1, '金额（元）')
        for y in income_list:
            worksheet.write(row, col, y['name'])
            worksheet.write(row, col + 1, y['money'])
            row += 1
        worksheet.write(row, 0, '合计')
        worksheet.write(row, 1, income)
        workbook.close()
        file = open("static/账户类型汇总.xlsx", 'rb')
        # 记录导出
        crud.create_export_data(db, params, user)
        return StreamingResponse(file, media_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    except Exception as e:
        params["status"] = 2
        crud.create_export_data(db, params, user)


class RechargeStatement(object):
    """充值报表"""

    def __init__(self):
        self.linkmysql = LinkMysql(env.DB_HISTORY)
        self.order_id = []
        # self.once_res=[]
        # self.moeny_data=[]

    def user_order_data(self, query_data):
        if not query_data:
            return []
        Logger().logger.info("获取order_id")
        for bus in query_data:
            bus.pop('id')
            if bus['reference_type'] == 'userRecharge':
                ref_type, o_id = bus['reference_number'].split('_')
                if o_id not in self.order_id:
                    self.order_id.append(o_id)
        Logger().logger.info("获取筛选条件")
        pay_discount = [i['uuid'] for i in query_data]
        pay_discount.append('_')  # 防止列表长度为1，sql查询tuple（）报错
        nick_sql = f"SELECT uuid,nick_name FROM v2_user where uuid in{tuple(pay_discount)}"
        nick_data = LinkMysql(env.DB_3YV2).query_mysql(nick_sql)
        nick_dict = {i['uuid']: i['nick_name'] for i in nick_data}
        if not self.order_id:
            for ni in query_data:
                ni['nick_name'] = nick_dict[ni['uuid']]
                ni['status'] = 1
            return query_data
        if len(self.order_id) == 1:
            o_sql = f"SELECT o.id,o.money,o.userid,v.nick_name,o.status,o.paychannel,o.sid,o.current FROM orders as o LEFT JOIN v2_user as v on o.userid=v.user_id where o.id={self.order_id[0]}"
        else:
            o_sql = f"SELECT o.id,o.money,o.userid,v.nick_name,o.status,o.paychannel,o.sid,o.current FROM orders as o LEFT JOIN v2_user as v on o.userid=v.user_id where o.id in{tuple(self.order_id)}"
        order_data = LinkMysql(env.DB_3YV2).query_mysql(o_sql)
        Logger().logger.info("查询支付配置")
        p_sql = "SELECT id,name FROM pay_config"
        pay_data = LinkMysql(env.DB_3YV2).query_mysql(p_sql)
        pay_dict = {}
        for i in pay_data:
            pay_dict[i['id']] = i['name']
        for x in query_data:
            if x['reference_type'] == 'userRecharge':
                ref_type, o_id = x['reference_number'].split('_')
            else:
                o_id = '1'
            for y in order_data:
                if o_id == str(y['id']):
                    x['user_id'] = y['userid']
                    x['nick_name'] = y['nick_name']
                    x['amount'] = y['money']
                    x['status'] = y['status']
                    x['paychannel'] = pay_dict.get(y['paychannel'], y['paychannel'])
                    x['sid'] = y['sid']
                else:
                    x['nick_name'] = nick_dict[x['uuid']]
                    x['status'] = 1
        Logger().logger.info(f"拼接的数据：{query_data[0]}")
        return query_data

    def query_data(self, db, page, size, order_number, uuid, sid, start_time, end_time, type, menu_id, month_type,export_status):
        """列表"""
        query = []
        query.append("type=1")
        if order_number:
            query.append(f"reference_number='{order_number}'")
        if uuid:
            query.append(f"uuid='{uuid}'")
        if sid:
            query.append(f"sid='{sid}' ")
        if type:
            query.append(f"type='{type}' ")
        if menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        else:
            querydata = db.query(Menuconfig).filter(Menuconfig.menu_type == 1)  # 1是充值
            reference_data = [QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        if month_type == 1:
            if start_time:
                query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
            if end_time:
                query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(month_type,start_time,end_time)
            count, once_res, moeny_data = self.statistics_data(month_type, query, page, size, now_month[1],export_status)
        else:
            query_data = self.query_add_time(start_time, end_time, query)
            count, once_res, moeny_data = self.thread_data(month_type, query_data, page, size,start_time,end_time,export_status)
        result = self.user_order_data(once_res)
        return count, result, moeny_data

    def query_add_time(self, start_time, end_time, old_query):
        data = []
        query = []
        query1 = []
        query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        query1.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        query1.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if old_query:
            query = query + old_query
            query1 = query1 + old_query
        data.append(query)
        data.append(query1)
        return data

    def statistics_data(self, month_type, query, page, size, now_month,export_status):
        '''统计'''
        if month_type == 1:
            if export_status:
                sql = f"SELECT a.id,a.uuid,a.amount/1000 as amount,FROM_UNIXTIME(a.create_time) as payment_time,a.reference_type,a.reference_number FROM assets_log_{now_month} as a where  {query}  ORDER BY id desc"
                once_res = self.linkmysql.query_mysql(sql)
                count=0
                moeny_data=1000
            else:
                count_sql = f"SELECT count(*) FROM assets_log_{now_month}  where {query}"
                count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
                sql = f"SELECT a.id,a.uuid,a.amount/1000 as amount,FROM_UNIXTIME(a.create_time) as payment_time,a.reference_type,a.reference_number FROM assets_log_{now_month} as a where  {query}  ORDER BY id desc limit {(int(page) - 1) * size},{size}"
                once_res = self.linkmysql.query_mysql(sql)
                money_sql = f"SELECT sum(amount) FROM assets_log_{now_month}  where {query}"
                moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") if \
                    self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") != None else 0

        else:
            if export_status:
                query1 = (' and '.join(query[0]))
                query2 = (' and '.join(query[1]))
                sql = f"SELECT  id,uuid,(amount/1000)  as amount,FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[0])}  where {query1}  UNION ALL SELECT id,uuid,amount/1000 as amount,FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[1])}  where {query2}  ORDER BY payment_time"
                once_res = self.linkmysql.query_mysql(sql)
                count = 0
                moeny_data = 1000
            else:
                count_sql = "SELECT sum(a.b) FROM ("f"SELECT count(*) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query[0]))}  UNION ALL SELECT count(*) FROM assets_log_{int(now_month[1])}  where {(' and '.join(query[1]))}) AS a "
                count = self.linkmysql.query_mysql(count_sql)[0].get("sum(a.b)")
                query1 = (' and '.join(query[0]))
                query2 = (' and '.join(query[1]))
                sql = f"SELECT  id,uuid,(amount/1000) as amount,FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[0])}  where {query1}  UNION ALL SELECT id,uuid,amount/1000 as amount,FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[1])}  where {query2}  ORDER BY payment_time desc limit {(int(page) - 1) * size},{size}"
                once_res = self.linkmysql.query_mysql(sql)
                money_sql = f"SELECT sum(a.b) FROM ("f"SELECT sum(amount) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query[0]))} UNION ALL SELECT sum(amount)FROM assets_log_{int(now_month[1])}  where {(' and '.join(query[1]))})  AS a "
                moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") if \
                    self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") != None else 0
        return count, once_res, moeny_data/1000

    def thread_data(self, month_type, query, page, size,start_time,end_time,export_status):
        now_month = get_month_last_month(month_type,start_time,end_time)
        count, once_res, moeny_data = self.statistics_data(month_type, query, page, size, now_month,export_status)
        return count, once_res, moeny_data

    def get_statements(self, db, data):
        """导出"""
        query = []
        if data.order_number:
            query.append(f"id={data.order_number} ")
        if data.user_id:
            query.append(f"uuid='{data.user_id}' ")
        if data.sid:
            query.append(f"sid='{data.sid}' ")
        if data.menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(data.menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
        if data.month_type == 1:
            if data.start_time:
                query.append(f" create_time >= {time_str_to_timestamp(data.start_time + ' 00:00:00')} ")
            if data.end_time:
                query.append(f" create_time < {time_str_to_timestamp(data.end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(data.month_type,data.start_time)
            once_res = self.data_delcy(data.month_type, query, now_month[1])
        else:
            query_data = self.query_add_time(query,data.start_time, data.end_time)
            now_month = get_month_last_month(data.month_type)
            once_res = self.data_delcy(data.month_type, query_data, now_month)
        return once_res

    def data_delcy(self, month_type, query, now_month):
        if month_type == 1:
            sql = f"SELECT a.uuid,a.amount,FROM_UNIXTIME(a.create_time,'%Y-%c-%d %h:%i:%s') as payment_time,a.reference_type,a.order_number FROM assets_log_{now_month} as a where  {query}"
            once_res = self.linkmysql.query_mysql(sql)
        else:
            query1 = (' and '.join(query[0]))
            query2 = (' and '.join(query[1]))
            sql = f"SELECT  id,uuid,amount,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as payment_time,reference_type,order_number FROM assets_log_{int(now_month[0])}  where {query1} UNION ALL SELECT id,uuid,amount,FROM_UNIXTIME(create_time,'%Y-%c-%d %h:%i:%s') as payment_time,reference_type,order_number FROM assets_log_{int(now_month[1])}  where {query2} "
            once_res = self.linkmysql.query_mysql(sql)
        return once_res


class WithdrawStatement(object):
    """提现报表"""

    def __init__(self):
        self.linkmysql = LinkMysql(env.DB_HISTORY)

    def query_add_time(self,query,start_time, end_time):
        query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        return query

    def user_data_structure(self, user_data, st_time, en_time):
        if not user_data:
            return user_data
        Logger().logger.info("通过assets_log业务数据查用户uuid")
        user_uuid_list = []
        for user in user_data:
            if user['uuid'] not in user_uuid_list:
                user_uuid_list.append(user['uuid'])
        if len(user_uuid_list) == 1:
            user_uuid_list.append(datetime.now().strftime('%Y%m%d%H%M%S'))
        Logger().logger.info("用户uuid查用户id")
        u_sql = f"select user_id,uuid from v2_user where uuid in{tuple(user_uuid_list)}"
        user_id_info = LinkMysql(env.DB_3YV2).query_mysql(u_sql)
        user_ids = []
        user_uuid_id = {}
        user_id_uuid = {}
        for i in user_id_info:
            user_ids.append(i['user_id'])
            user_uuid_id[i['uuid']] = i['user_id']
            user_id_uuid[i['user_id']] = i['uuid']
        if len(user_ids) == 1:
            user_ids.append(datetime.now().strftime('%Y%m%d%H%M%S'))
        Logger().logger.info("用户id查用户所属公会")
        condition = []
        if st_time:
            condition.append(f" t.update_time>={time_str_to_timestamp(st_time + ' 00:00:00')}")
        if en_time:
            condition.append(f" t.update_time<{time_str_to_timestamp(en_time + ' 23:59:59')}")
        if condition:
            gu_sql = f"select t.userid,t.usernumber,t.nickname,t.current,t.update_time,t.money,t.final_money,g.guild_name from tixian_order as t LEFT JOIN guild as g on t.guild_id=g.id where t.userid in{tuple(user_ids)} and {(' and '.join(condition))}"
        else:
            gu_sql = f"select t.userid,t.usernumber,t.nickname,t.current,t.update_time,t.money,t.final_money,g.guild_name from tixian_order as t LEFT JOIN guild as g on t.guild_id=g.id where t.userid in{tuple(user_ids)}"
        guild_user_info = LinkMysql(env.DB_3YV2).query_mysql(gu_sql)
        user_to_guild = {}
        for ug in guild_user_info:
            ug['uuid'] = user_id_uuid[ug['userid']]
            user_to_guild[ug['userid']] = ug.get('guild_name','')
        Logger().logger.info("拼接数据！！！！")
        for us in user_data:
            for tx in guild_user_info:
                amount = Decimal(us['amount']).quantize(Decimal("0.00"))
                if tx['uuid'] == us['uuid'] and int(amount) == tx['money']:
                    user_id = user_uuid_id.get(us['uuid'])
                    us['guild_name'] = user_to_guild.get(user_id)
                    us['dec_money'] = tx['money'] * 0.05
                    us['withdrawal_time'] = time_str_to_timestamp(str(tx['current']))
                    us['update_time'] = tx['update_time']
                    us['final_money'] = Decimal(tx['final_money']).quantize(Decimal("0.00"))
                    us['usernumber'] = tx['usernumber']
                    us['nickname'] = tx['nickname']
                    us['money'] = tx['money']
        return user_data

    def get_user_withdraw_cash(self, db, page, size, uuid, status, start_time, end_time, month_type, menu_id):
        query = []
        if uuid:
            query.append(f" uuid='{uuid}'")
        if status:
            query.append(f"status={status} ")
        if menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
            query.append(f"type=0")
        else:
            querydata = db.query(Menuconfig).filter(Menuconfig.menu_type == 3)  # 3是用户提现
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
            query.append(f"type = 0")
        if month_type == 1:
            if start_time:
                query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
            if end_time:
                query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(month_type,start_time,end_time)
            count, once_res, moeny_data,reality_moeny = self.dispose_user(month_type, query, page, size, now_month[1])
        else:
            query_data = self.query_add_time(query,start_time, end_time)
            now_month = get_month_last_month(month_type,start_time,end_time)
            count, once_res, moeny_data,reality_moeny = self.dispose_user(month_type, query_data, page, size, now_month)
        res_user_data = self.user_data_structure(once_res, start_time, end_time)
        return count, res_user_data, moeny_data/1000,reality_moeny/1000

    def dispose_user(self, month_type, query, page, size, now_month):
        if month_type == 1:
            count_sql = f"SELECT count(*) FROM assets_log_{now_month}  where {query}"
            count = self.linkmysql.query_mysql(count_sql)[0].get("count(*)")
            sql = f'SELECT uuid,(amount/1000) as amount,a.reference_type,a.reference_number,FROM_UNIXTIME(a.create_time) as payment_time,a.amount_type FROM assets_log_{now_month} as a where {query} ORDER BY id desc limit {(int(page) - 1) * size},{size}'
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(amount) FROM assets_log_{now_month}  where {query} "
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") if \
                self.linkmysql.query_mysql(money_sql)[0].get("sum(amount)") != None else 0
            query_type=query.replace('type = 0','type = 1')   #收入
            income_sql = f"SELECT sum(amount) FROM assets_log_{now_month}  where {query_type} "
            moeny_income = self.linkmysql.query_mysql(income_sql)[0].get("sum(amount)") if \
                self.linkmysql.query_mysql(income_sql)[0].get("sum(amount)") != None else 0
            reality_moeny=moeny_data-abs(moeny_income)

        else:
            count_sql = "SELECT sum(a.b) FROM ("f"SELECT count(*) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query))}  UNION ALL SELECT count(*) FROM assets_log_{int(now_month[1])}  where {(' and '.join(query))})  AS a "
            count = self.linkmysql.query_mysql(count_sql)[0].get("sum(a.b)")
            sql = f"SELECT  id,uuid,(amount/1000) as amount ,amount_type, FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[0])}  where {(' and '.join(query))}  UNION ALL SELECT id,uuid,(amount/1000) as amount,amount_type, FROM_UNIXTIME(create_time) as payment_time,reference_type,reference_number FROM assets_log_{int(now_month[1])}  where {(' and '.join(query))}   ORDER BY id desc limit {(int(page) - 1) * size},{size}"
            once_res = self.linkmysql.query_mysql(sql)
            money_sql = f"SELECT sum(a.b) FROM ("f"SELECT sum(amount) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query))}   UNION ALL SELECT sum(amount)FROM assets_log_{int(now_month[1])}  where {(' and '.join(query))}  ) AS a "
            moeny_data = self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") if \
                self.linkmysql.query_mysql(money_sql)[0].get("sum(a.b)") != None else 0
            query[1] = 'type = 1'   #收入
            income_sql = f"SELECT sum(a.b) FROM ("f"SELECT sum(amount) as b FROM assets_log_{int(now_month[0])}  where {(' and '.join(query))}   UNION ALL SELECT sum(amount)FROM assets_log_{int(now_month[1])}  where {(' and '.join(query))}  ) AS a "
            moeny_income = self.linkmysql.query_mysql(income_sql)[0].get("sum(a.b)") if \
                self.linkmysql.query_mysql(income_sql)[0].get("sum(a.b)") != None else 0
            reality_moeny=moeny_data-abs(moeny_income)
        return count, once_res, moeny_data,reality_moeny

    def structure_data(self, guild_data, s_time, e_time):

        guild_query = []
        Logger().logger.info("拼接数据！！！")
        if s_time:
            guild_query.append(f" t.update_time>={time_str_to_timestamp(s_time + ' 00:00:00')} ")
        if e_time:
            guild_query.append(f" t.update_time<{time_str_to_timestamp(e_time + ' 23:59:59')} ")
        if guild_query:
            gui_sql = f"SELECT g.id,g.guild_name,g.uuid,t.withdrawal_time,t.update_time,t.money,t.dec_money,t.finalMoney from guild_ti_xian as t LEFT JOIN guild as g on t.guild_id=g.id where {(' and '.join(guild_query))}"
        else:
            gui_sql = "SELECT g.id,g.guild_name,g.uuid,t.withdrawal_time,t.update_time,t.money,t.dec_money,t.finalMoney from guild_ti_xian as t LEFT JOIN guild as g on t.guild_id=g.id"
        guild_info = LinkMysql(env.DB_3YV2).query_mysql(gui_sql)
        for guild in guild_data:
            for i in guild_info:
                amount = Decimal(guild['amount']).quantize(Decimal("0.00"))
                if guild['uuid'] == i['uuid'] and str(amount) == i['finalMoney']:
                    guild['withdrawal_time'] = i['withdrawal_time']
                    guild['update_time'] = i['update_time']
                    guild['guild_id'] = i['id']
                    guild['guild_name'] = i['guild_name']
                    guild['money'] = i['money']
                    guild['dec_money'] = i['dec_money']
                    guild['finalMoney'] = Decimal(i['finalMoney']).quantize(Decimal("0.00"))
        Logger().logger.info("完成！！！")
        return guild_data

    def get_guild_withdraw_cash(self, db, page, size, name, status, start_time, end_time, month_type, menu_id):
        """公会提现"""
        query =[]
        if name:
            query.append(f" nickname like '%{name}%' ")
        if status:
            query.append(f"status={status} ")
        if menu_id:
            querydata = db.query(Menuconfig).filter(Menuconfig.id.in_(tuple(menu_id)))
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
            query.append(f"type = 0")
        else:
            querydata = db.query(Menuconfig).filter(Menuconfig.menu_type == 4)  # 4是公会提现
            reference_data = [
                QueryAllData.serialization(item, remove={'menu_name', 'remark', 'menu_type', 'create_time', 'id'}) for
                item in querydata]
            if len([item.get("menu_label") for item in reference_data]) > 1:
                reference_type = tuple([item.get("menu_label") for item in reference_data])
            else:
                reference_type = "('" + [item.get("menu_label") for item in reference_data][0] + "')"
            query.append(f"reference_type in {reference_type}")
            query.append(f"type = 0")
        if month_type == 1:
            if start_time:
                query.append(f" create_time >= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
            if end_time:
                query.append(f" create_time < {time_str_to_timestamp(end_time + ' 23:59:59')} ")
            query = ' and '.join(query)
            now_month = get_month_last_month(month_type,start_time,end_time)
            count, once_res, moeny_data,reality_moeny = self.dispose_user(month_type, query, page, size, now_month[1])
        else:
            query_data = self.query_add_time(query,start_time, end_time)
            now_month = get_month_last_month(month_type,start_time,end_time)
            count, once_res, moeny_data,reality_moeny = self.dispose_user(month_type, query_data, page, size, now_month)
        # 数据构造
        res_list = self.structure_data(once_res, start_time, end_time)
        return count, res_list, moeny_data/1000, reality_moeny/1000


class FinanceFix(object):

    @staticmethod
    def get_finance_fix_data(page, size, start_time, end_time):
        """财务修复"""
        finance_filters = []
        if start_time:
            finance_filters.append(f" create_time <= {time_str_to_timestamp(start_time + ' 00:00:00')} ")
        if end_time:
            finance_filters.append(f" create_time <= {time_str_to_timestamp(end_time + ' 23:59:59')} ")
        if finance_filters:
            count_sql = f"select count(id) as num from finance_fix_log where {' and '.join(finance_filters)}"
            data_sql = f"select id,type,money,unique_tag,amount_type,operator,create_time,remark from finance_fix_log where {' and '.join(finance_filters)} order by id DESC limit {(int(page) - 1) * size},{size}"
        else:
            count_sql = f"select count(id) as num from finance_fix_log"
            data_sql = f"select id,type,money,unique_tag,amount_type,operator,create_time,remark from finance_fix_log order by id DESC limit {(int(page) - 1) * size},{size}"
        with ThreadPoolExecutor(max_workers=2) as pool:
            future1 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, count_sql)
            future2 = pool.submit(LinkMysql(env.DB_3YV2).query_mysql, data_sql)
        total = future1.result()
        res = future2.result()
        if res:
            result = []
            for i in res:
                if i['type'] != 0:
                    i['name'] = i['unique_tag']
                i['create_time'] = timestamp_to_time_str(i['create_time'])
                i['money'] = float(i['money'])
                result.append(i)
            return result, total[0]['num']
        return [], 0


def create_menu(db: Session, menu: schemas.MenuAdd):
    try:
        db_menu = Menuconfig(menu_name=menu.menu_name, menu_label=menu.menu_label, menu_type=menu.menu_type,
                             create_time=datetime.now(), remark=menu.remark if menu.remark != '' else '')
        db.add(db_menu)
        db.commit()
        db.refresh(db_menu)
    except Exception as e:
        print(e)
        return {}
    return db_menu


def get_menu_name(db: Session, menu_name: str):
    return db.query(Menuconfig).filter(Menuconfig.menu_name == menu_name).first()


def get_menu_id(db: Session, id: str):
    return db.query(Menuconfig).filter(Menuconfig.id == id).first()


def get_menu_update(db: Session, data):
    query_data = db.query(Menuconfig).filter(Menuconfig.id == data.id).update({Menuconfig.menu_name: data.menu_name,
                                                                               Menuconfig.menu_label: data.menu_label,
                                                                               Menuconfig.menu_type: data.menu_type,
                                                                               Menuconfig.remark: data.remark,
                                                                               Menuconfig.create_time: datetime.now()
                                                                               })
    db.commit()
    return query_data


def get_menu_delete(db: Session, id):
    query_data = db.query(Menuconfig).filter(Menuconfig.id == id).delete()
    db.commit()
    return query_data


def get_menu_list(db: Session, page, size, menu_name, menu_label, menu_type):
    querys = []
    if menu_name:
        querys.append(Menuconfig.menu_name.like(f'%{menu_name}%'))
    if menu_label:
        querys.append(Menuconfig.menu_label == menu_label)
    if menu_type:
        querys.append(Menuconfig.menu_type == menu_type)
    if querys:
        querydata = db.query(Menuconfig).filter(*querys).order_by(
            Menuconfig.id.desc()).offset((int(page) - 1) * size).limit(size)
        data = [QueryAllData.serialization(item) for item in querydata]
    else:
        querydata = db.query(Menuconfig).filter().order_by(
            Menuconfig.id.desc()).offset((int(page) - 1) * size).limit(size)
        data = [QueryAllData.serialization(item) for item in querydata]
    count = db.query(func.count(Menuconfig.id)).filter().scalar()
    return data, count


def get_menu_config(db: Session, menu_type):
    querys = []
    if menu_type:
        querys.append(Menuconfig.menu_type == menu_type)
    querydata = db.query(Menuconfig).filter(*querys).order_by(
        Menuconfig.id.desc())
    data = [QueryAllData.serialization(item, remove={'create_time', 'remark'}) for item in querydata]
    return data
