from sqlalchemy import Column, Integer, String, Float, DateTime
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class Recharge(Base, SerializerMixin):
    """充值表"""
    __tablename__ = "recharge"

    id = Column(Integer, primary_key=True, index=True)
    order_number = Column(String(255), comment="订单编号")
    user_id = Column(Integer, comment="用户ID")
    user_number = Column(Integer, comment="朱贝号")
    nick_name = Column(String(255), comment="昵称")
    money = Column(Float, comment="金额")
    pay_channel = Column(Integer, comment="充值渠道(-1:公会后台 0:后台添加，1:支付宝,2:网银,4:神州行充值卡,5:联通充值,3:骏网充值,"
                                          "6第三方充值,7利用公会充值账号充值)")
    sid = Column(String(255), comment="订单序列号(在后台充值记录的是添加的备注,通过网银等充值记录的是充值成功第三方返回的订单id)")
    last_update = Column(Integer, comment="最后更新时间")
    current = Column(DateTime, comment="回调成功时间")
    payment_time = Column(Integer, comment="实际第三方订单支付时间")


class UserWC(Base, SerializerMixin):
    """用户提现"""
    __tablename__ = "user_withdraw_cash"

    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, comment="用户ID")
    bank_code = Column(String(255), comment="银行编号")
    user_number = Column(Integer, comment="用户的视频号(朱贝号)")
    nick_name = Column(String(255), comment="昵称")
    true_name = Column(String(255), comment="用户真实姓名")
    id_card = Column(String(255), comment="用户的身份证号码")
    account = Column(String(255), comment="提现账号")
    status = Column(Integer, comment="申请的进度，0发起申请，1处理中，3成功,4失败,5已到账,6未到账")
    money = Column(Float, comment="金额")
    platform_service_fee = Column(String(50), comment="平台服务费")
    third_service_fee = Column(String(50), comment="第三方费用")
    final_money = Column(String(50), comment="实得收益")
    current = Column(DateTime, comment="回调成功时间")


class GuildWC(Base, SerializerMixin):
    """公会提现"""
    __tablename__ = "guild_withdraw_cash"

    id = Column(Integer, primary_key=True, index=True)
    guild_id = Column(Integer, comment="公会ID")
    merchants_id = Column(Integer, comment="招商ID")
    account = Column(String(255), comment="账号")
    guild_name = Column(String(255), comment="公会名称")
    money = Column(Float, comment="提现金额")
    status = Column(Integer, comment="提现状态，1为处理中，2为成功，3为拒绝")
    platform_service_fee = Column(String(50), comment="平台服务费")
    third_service_fee = Column(String(50), comment="第三方费用")
    final_money = Column(String(50), comment="实得收益")
    create_time = Column(DateTime, comment="创建时间")
    update_time = Column(DateTime, comment="修改时间")


class Settlement(Base, SerializerMixin):
    """公会结算"""
    __tablename__ = "guild_settlement"

    id = Column(Integer, primary_key=True, index=True)
    guild_id = Column(Integer, comment="公会ID")
    guild_name = Column(String(255), comment="公会名称")
    is_calculate = Column(String(10), comment="是否结算")
    is_settlement = Column(String(10), comment="是否结款")
    status = Column(Integer, comment="状态，0待结算，1待结款，2已完成")
    all_money = Column(Float, comment="应结款")
    account = Column(String(255), comment="账号")
    bank_name = Column(String(255), comment="开户行名称")
    bank_no = Column(String(255), comment="户头名称")
    create_time = Column(DateTime, comment="申请结算时间")
