from sqlalchemy import Column, Integer, String, DateTime, Float
from core.storage.db import Base
from datetime import datetime


class Statement(Base):
    __tablename__ = "statement"

    id = Column(Integer, primary_key=True, index=True)
    order_number = Column(String(50), unique=True, index=True, comment='订单号')
    user_id = Column(Integer, index=True, comment='用户ID')
    zb_number = Column(String(50), comment='朱贝号')
    nickname = Column(String(50), comment='昵称')
    recharge_amount = Column(Float, comment='充值金额')
    recharge_channel = Column(String(50), index=True, comment='充值渠道')
    flowing_water_number = Column(String(50), unique=True, index=True, comment='交易流水号')
    pay_time = Column(DateTime, comment='支付时间')
    callback_time = Column(DateTime, comment='回调成功时间')
    actual_pay_time = Column(DateTime, comment='实际支付时间')
    create_time = Column(DateTime, default=datetime.now(), comment='创建时间')



