from sqlalchemy.orm import Session
from models import statement as models
from app.api.statement import schemas


def get_statement(db: Session, user_id: int):
    return db.query(models.Statement).filter(models.Statement.id == user_id)


def get_statement_by_name(db: Session, username: str):
    return db.query(models.Statement).filter(models.Statement.username == username).first()


def get_statements(db: Session, page: int = 0, size: int = 10):
    return db.query(models.Statement).offset(page).limit(size).all()


def create_statementr(db: Session, user: schemas.StatementCreate):
    db_user = models.Statement(order_number=user.order_number, user_id=user.user_id, zb_number=user.zb_number,
                               nickname=user.nickname, recharge_amount=user.recharge_amount, recharge_channel=user.recharge_channel,
                               flowing_water_number=user.flowing_water_number)
    db.add(db_user)
    db.commit()
    db.refresh(db_user)
    return db_user
