from pydantic import BaseModel


class StatementBase(BaseModel):
    user_id: int
    zb_number: int
    order_number: int


class StatementCreate(StatementBase):

    nickname: str
    recharge_amount: float
    recharge_channel: str
    flowing_water_number: int


class Statement(StatementBase):
    id: int

    class Config:
        orm_mode = True
