import json
from fastapi import status
from fastapi.responses import Response


class HttpMessage(object):
    SUCCESS = "操作成功"
    USER_EXIST = "用户已存在"
    HFDU = "登录成功"


class HttpResultResponse(Response):
    def __init__(self, code=None, msg=None, **kwargs):
        result_dict = {
            'code': code if code else status.HTTP_200_OK,
            'msg': msg if code else HttpMessage.SUCCESS
        }

        result_dict = {**result_dict, **kwargs}
        super().__init__(
            content=json.dumps(result_dict),
            media_type="application/json",
            status_code=result_dict.get('code')
        )
