# 获取yaml配置token
import requests
import yaml
from core.config.env import env
from libs.log_utils import Logger


def get_yaml_token():
    url = env.LOGIN_URL
    data = {
        "username": env.NAME,
        "password": env.PWD
    }
    response = requests.post(url=url, data=data)
    if response.status_code == 200:
        token = response.json().get("accessToken")
        return token
    return ""


# 创建本地yaml文件
def create_yaml():
    """
    自动生成yaml文件
    """
    token = get_yaml_token()
    url = f"{env.NACOS_URL}{env.NACOSCONFIG}&accessToken={token}"
    try:
        nacos_config_data = requests.get(url=url).json()
        content = yaml.safe_load(nacos_config_data.get("content"))
        with open(env.PEM_PATH + "apollo.yaml", "w", encoding='utf-8') as f:  # 写文件
            yaml.dump(data=content, stream=f, allow_unicode=True, width=1000)
            f.close()
        Logger(20).logger.info("yaml初始化成功")
    except Exception as e:
        Logger(40).logger.error(f"生成yaml文件失败,原因:{str(e)}")
