from sqlalchemy import Column, Integer, String, Float, DateTime, DECIMAL, Text
from core.storage.db import Base
from sqlalchemy_serializer import SerializerMixin


class Recharge(Base, SerializerMixin):
    """充值表"""
    __tablename__ = "recharge"

    id = Column(Integer, primary_key=True, index=True)
    order_number = Column(String(255), comment="订单编号")
    user_id = Column(Integer, comment="用户ID")
    user_number = Column(Integer, comment="朱贝号")
    nick_name = Column(String(255), comment="昵称")
    money = Column(Float, comment="金额")
    pay_channel = Column(Integer, comment="充值渠道(-1:公会后台 0:后台添加，1:支付宝,2:网银,4:神州行充值卡,5:联通充值,3:骏网充值,"
                                          "6第三方充值,7利用公会充值账号充值)")
    sid = Column(String(255), comment="订单序列号(在后台充值记录的是添加的备注,通过网银等充值记录的是充值成功第三方返回的订单id)")
    last_update = Column(Integer, comment="最后更新时间")
    current = Column(DateTime, comment="回调成功时间")
    payment_time = Column(Integer, comment="实际第三方订单支付时间")

    __table_args__ = {'comment': '用户充值表'}


class UserWC(Base, SerializerMixin):
    """用户提现"""
    __tablename__ = "user_withdraw_cash"

    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, comment="用户ID")
    bank_code = Column(String(255), comment="银行编号")
    user_number = Column(Integer, comment="用户的视频号(朱贝号)")
    nick_name = Column(String(255), comment="昵称")
    true_name = Column(String(255), comment="用户真实姓名")
    id_card = Column(String(255), comment="用户的身份证号码")
    account = Column(String(255), comment="提现账号")
    status = Column(Integer, comment="申请的进度，0发起申请，1处理中，3成功,4失败,5已到账,6未到账")
    money = Column(Float, comment="金额")
    platform_service_fee = Column(String(50), comment="平台服务费")
    third_service_fee = Column(String(50), comment="第三方费用")
    final_money = Column(String(50), comment="实得收益")
    current = Column(DateTime, comment="回调成功时间")

    __table_args__ = {'comment': '用户提现表'}


class GuildWC(Base, SerializerMixin):
    """公会提现"""
    __tablename__ = "guild_withdraw_cash"

    id = Column(Integer, primary_key=True, index=True)
    guild_id = Column(Integer, comment="公会ID")
    merchants_id = Column(Integer, comment="招商ID")
    account = Column(String(255), comment="账号")
    guild_name = Column(String(255), comment="公会名称")
    money = Column(Float, comment="提现金额")
    status = Column(Integer, comment="提现状态，1为处理中，2为成功，3为拒绝")
    platform_service_fee = Column(String(50), comment="平台服务费")
    third_service_fee = Column(String(50), comment="第三方费用")
    final_money = Column(String(50), comment="实得收益")
    create_time = Column(DateTime, comment="创建时间")
    update_time = Column(DateTime, comment="修改时间")

    __table_args__ = {'comment': '公会提现表'}


class Settlement(Base, SerializerMixin):
    """公会结算"""
    __tablename__ = "guild_settlement"

    id = Column(Integer, primary_key=True, index=True)
    guild_id = Column(Integer, comment="公会ID")
    guild_name = Column(String(255), comment="公会名称")
    is_calculate = Column(String(10), comment="是否结算")
    is_settlement = Column(String(10), comment="是否结款")
    status = Column(Integer, comment="状态，0待结算，1待结款，2已完成")
    all_money = Column(Float, comment="应结款")
    account = Column(String(255), comment="账号")
    bank_name = Column(String(255), comment="开户行名称")
    bank_no = Column(String(255), comment="户头名称")
    create_time = Column(DateTime, comment="申请结算时间")

    __table_args__ = {'comment': '公会结算表'}


class Paymentlog(Base, SerializerMixin):
    """打款记录"""
    __tablename__ = "payment_log"
    id = Column(Integer, primary_key=True, index=True)
    cont = Column(String(255), comment="打款备注")
    money = Column(DECIMAL(10, 2), comment="打款金额", default='0.00')
    url = Column(String(255), comment="凭证图片", default='0')
    uuid = Column(String(255), comment="出账账户")
    create_time = Column(DateTime, comment="打款时间")

    __table_args__ = {'comment': '打款记录表'}


class Fiaccount(Base, SerializerMixin):
    '''
    账户
    '''
    __tablename__ = "fi_account"
    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(100), comment="账户名称")
    unique_tag = Column(String(100), comment="唯一标记")
    beneficiary = Column(String(100), comment="受益人")
    description = Column(String(100), comment="描述信息")
    uuid = Column(String(60), comment="用户id", index=True)
    create_time = Column(DateTime, comment="创建时间")
    config_key = Column(String(150), comment="配置key,和api接口约定好的标识")
    income = Column(Text, comment="入账")
    output = Column(Text, comment="出账")
    operator = Column(String(255), comment="")
    operator_id = Column(Integer, comment="操作id")


class Fitransferlog(Base, SerializerMixin):
    '''
    转账列表, 商量说存id
    '''
    __tablename__ = "fi_transfer_log"
    id = Column(Integer, primary_key=True, index=True)
    amount = Column(DECIMAL(20, 6), comment="转入金额")
    dst_id = Column(Integer, comment="转出账户id")
    create_time = Column(Integer, comment="创建时间")
    transfer_id = Column(Integer, comment="转入账户id")
    type = Column(Integer, comment="转账类型（0：对企业，1：对个人）")
    nick_name = Column(String(100), comment="用户昵称")
    remark = Column(String(255), comment="转账备注")
    transfer_type = Column(String(255), comment="转账类型")
    operator = Column(String(255), comment="操作员")

    __table_args__ = {'comment': '转账信息表'}


class FinanceFixLog(Base, SerializerMixin):
    """财务修复日志"""
    __tablename__ = "finance_fix_log"
    id = Column(Integer, primary_key=True, index=True)
    type = Column(Integer, comment="0系统账户1私有账户")
    money = Column(Float, comment="修复金额")
    amount_type = Column(String(128), comment="账户类型")
    remark = Column(String(255), comment="备注")
    operator = Column(String(255), comment="操作员")
    account_id = Column(Integer, comment="账户id")
    create_time = Column(DateTime, comment="创建时间")

    __table_args__ = {'comment': '财务修复日志'}



class Account_log(Base, SerializerMixin):
    """账户修复记录表"""
    __tablename__ = "account_log"
    id = Column(Integer, primary_key=True, index=True)
    cont = Column(String(255), comment="备注")
    out_money = Column(DECIMAL(11,3), comment="出账")
    entry_money = Column(DECIMAL(11,3), comment="入账")
    create_time = Column(DateTime, comment="创建时间")
    befor_out_money = Column(DECIMAL, comment="数据产生之前的全部数据")
    befor_entry_money = Column(DECIMAL(11,3), comment="创建时间之前的所有数据总和")
    uuid = Column(String(255), comment="所属uuid")
    from_time = Column(DateTime, comment="数据所属时间")
    type = Column(Integer, comment="uuid类型0系统账户1公会账户2用户账户3背包账户")

    __table_args__ = {'comment': '财务修复日志'}

