from datetime import datetime
from app.api.statement import crud, schemas
from app import get_db
from fastapi import Depends, APIRouter, File
from sqlalchemy.orm import Session
from app.api.statement.crud import RechargeStatement, WithdrawStatement
from app.api.statement.guild import GuildSet, paymentset_guild_data, outon_account_data, accout_list_data
from app.api.statement.schemas import PaymentWithdrawalList, PaymentAdd, PaymentAccountlList
from libs.img_code import new_upload_file, random_number
from libs.result_format import HttpResultResponse
from models.recharge import Paymentlog, Fiaccount

router = APIRouter()


@router.post("/recharge/list")
def statement_recharge_list(data: schemas.StatementList, db: Session = Depends(get_db)):
    """充值报表列表"""
    statement_list, total, money = RechargeStatement().get_statements(db, data, 1)
    return HttpResultResponse(total=total, count=float(money), data=statement_list)


@router.post("/derive/excel")
def statement_derive_excel(data: schemas.StatementList, db: Session = Depends(get_db)):
    """充值报表导出"""
    statement_list = RechargeStatement().get_statements(db, data)
    return crud.data_to_file(statement_list, "充值报表")


@router.post("/userWithdrawal/list")
def user_withdrawal_list(data: schemas.UserWithdrawalList, db: Session = Depends(get_db)):
    """用户提现列表"""
    statement_list, total, money, final_money = WithdrawStatement().get_user_withdraw_cash(db, data)
    return HttpResultResponse(total=total, count=float(money), actual_count=final_money, data=statement_list)


@router.post("/guildWithdrawal/list")
def guild_withdrawal_list(data: schemas.GuildWithdrawalList, db: Session = Depends(get_db)):
    """公会提现列表"""
    guild_list, total, money, final_money = WithdrawStatement().get_guild_withdraw_cash(db, data)
    return HttpResultResponse(total=total, count=float(money), actual_count=final_money, data=guild_list)


@router.post("/guild/settlement")
def guild_settlement_list(data: schemas.GuildWithdrawalList, db: Session = Depends(get_db)):
    """公会结算"""
    guild_list, total = GuildSet().get_guild_data(db, data)
    return HttpResultResponse(total=total, data=guild_list)



@router.post("/guild/payment")
def guild_payment_list(data:PaymentWithdrawalList,db: Session = Depends(get_db)):
    """打款记录"""
    payment_list, total = paymentset_guild_data(db,Paymentlog,data.dict(exclude_none=True))
    return HttpResultResponse(total=total, data=payment_list)


@router.post('/upload')
async def uploadFile(a_file: bytes = File(...)):
    a_content = a_file
    image_name=random_number()
    cos_path =new_upload_file(a_content,image_name)
    return HttpResultResponse(data=cos_path)


@router.post("/payment/add")
def guild_payment_list(data:PaymentAdd,db: Session = Depends(get_db)):
    """提交打款"""
    dataPayment=Paymentlog(uuid=data.uuid,money=data.money,cont=data.cont,url=data.url,create_time=datetime.now())
    db.add(dataPayment)
    db.commit()
    db.refresh(dataPayment)
    db.close()
    return HttpResultResponse(data='')



@router.get("/onaccount")
def outon_account(db: Session = Depends(get_db)):
    """转出和转入账户人员列表"""
    account_list, total = outon_account_data(db, Fiaccount,{})
    return HttpResultResponse(total=total, data=account_list)



@router.post("/transferlist")
def outon_account(data:PaymentAccountlList,db: Session = Depends(get_db)):
    """转账列表"""
    account_list, total = accout_list_data(db, Fiaccount,data.dict(exclude_none=True))
    return HttpResultResponse(total=total, data=account_list)



