from fastapi import Depends, APIRouter
from sqlalchemy.orm import Session
from app import get_db
from app.api.margin import schemas, crud
from libs.result_format import HttpResultResponse

router = APIRouter()


@router.post("/list")
def guild_margin_list(data: schemas.GuildMarginList, db: Session = Depends(get_db)):
    """保证金列表"""
    result = crud.get_margin(db, data)
    return HttpResultResponse(total=len(result), data=result[int(data.page-1)*data.size:data.page*data.size])



