from pydantic import BaseModel
from typing import Optional


class UserBase(BaseModel):
    username: str


class UserCreate(UserBase):
    remark: Optional[str] = None
    role_id: int


class User(UserBase):
    id: int

    class Config:
        orm_mode = True


class UserLoginForm(BaseModel):
    username: str
    password: str
    verify: str


class GoogleCode(BaseModel):
    username: str


class GoogleLogin(BaseModel):
    username: str
    password: str
    google_key: str
    google_code: str


class PermissionCreate(BaseModel):

    id: int
    remark: str
    role_id: int


class UserList(BaseModel):
    page: Optional[int] = None
    size: Optional[int] = None
    username: Optional[str] = ""
