from typing import Optional
from pydantic import BaseModel


class AccountCreate(BaseModel):
    name: str
    remark: str
    unique_tag: str
    config_key: str


class AccountList(BaseModel):
    name: Optional[str] = None
    page: Optional[int] = None
    size: Optional[int] = None


class AccountUpdate(BaseModel):
    id: int
    name: str
    remark: str
    income: list
    output: list
