from fastapi import APIRouter
from app.api.users import views as u_view
from app.api.statement import views as s_view
from app.api.role import views as r_view
from app.api.account import views as a_view

api_router = APIRouter()
api_router.include_router(u_view.router, prefix="/users", tags=["users"])
api_router.include_router(s_view.router, prefix="/statement", tags=["statement"])
api_router.include_router(r_view.router, prefix="/role", tags=["role"])
api_router.include_router(a_view.router, prefix="/account", tags=["account"])
