from app.api.statement import crud, schemas
from app import get_db
from fastapi import Depends, APIRouter
from sqlalchemy.orm import Session
from app.api.statement.crud import RechargeStatement, WithdrawStatement
from app.api.statement.guild import GuildSet
from libs.result_format import HttpResultResponse

router = APIRouter()


@router.post("/recharge/list")
def statement_recharge_list(data: schemas.StatementList, db: Session = Depends(get_db)):
    """充值报表列表"""
    statement_list, total, money = RechargeStatement().get_statements(db, data, 1)
    return HttpResultResponse(total=total, count=float(money), data=statement_list)


@router.post("/derive/excel")
def statement_derive_excel(data: schemas.StatementList, db: Session = Depends(get_db)):
    """充值报表导出"""
    statement_list = RechargeStatement().get_statements(db, data)
    return crud.data_to_file(statement_list, "充值报表")


@router.post("/userWithdrawal/list")
def user_withdrawal_list(data: schemas.UserWithdrawalList, db: Session = Depends(get_db)):
    """用户提现列表"""
    statement_list, total, money, final_money = WithdrawStatement().get_user_withdraw_cash(db, data)
    return HttpResultResponse(total=total, count=float(money), actual_count=final_money, data=statement_list)


@router.post("/guildWithdrawal/list")
def guild_withdrawal_list(data: schemas.GuildWithdrawalList, db: Session = Depends(get_db)):
    """公会提现列表"""
    guild_list, total, money, final_money = WithdrawStatement().get_guild_withdraw_cash(db, data)
    return HttpResultResponse(total=total, count=float(money), actual_count=final_money, data=guild_list)


@router.post("/guild/settlement")
def guild_settlement_list(data: schemas.GuildWithdrawalList, db: Session = Depends(get_db)):
    """公会结算"""
    guild_list, total = GuildSet().get_guild_data(db, data)
    return HttpResultResponse(total=total, data=guild_list)


@router.post("/guild/update")
def guild_update_list(data: schemas.GuildUpdate, db: Session = Depends(get_db)):
    """公会结算"""
    GuildSet().update_guild_info(db, data)
    return HttpResultResponse()
