from datetime import datetime
from sqlalchemy.orm import Session
from app.api.role import schemas
from models import roles as models


def get_role_by_name(db: Session, role_name: str):
    return db.query(models.Role).filter(models.Role.role_name == role_name).first()


def get_roles(db: Session, param):
    page = param.page if param.page else 1
    size = param.size if param.size else 10
    name = param.role_name if param.role_name else ""
    if name:
        return db.query(models.Role).filter(models.Role.role_name.like(f'%{name}%')).offset((int(page) - 1) * size).\
            limit(page * size).all()
    else:
        return db.query(models.Role).offset((int(page) - 1) * size).limit(page * size).all()


def create_role(db: Session, user: schemas.RoleCreate):
    try:
        db_user = models.Role(role_name=user.role_name, authority=",".join(map(str, user.authority)),
                              remark=user.remark, create_time=datetime.now())
        db.add(db_user)
        db.commit()
        db.refresh(db_user)
    except Exception as e:
        print(e)
        return {}
    return db_user


def update_role(db: Session, role_info):

    if role_info.role_name:
        db.query(models.Role).filter(models.Role.id == role_info.id).update(
            {models.Role.role_name: role_info.role_name})
    if role_info.remark:
        db.query(models.Role).filter(models.Role.id == role_info.id).update(
            {models.Role.remark: role_info.remark})
    if role_info.authority:
        db.query(models.Role).filter(models.Role.id == role_info.id).update(
            {models.Role.authority: ','.join(map(str, role_info.authority))})
    db.commit()


def delete_role(db: Session, role_id: int):

    db.query(models.Role).filter(models.Role.id == role_id).delete()
    db.commit()
