from sqlalchemy import Column, Integer, String, DateTime, Text
from core.storage.db import Base


class Role(Base):
    __tablename__ = "role"

    id = Column(Integer, primary_key=True, index=True)
    role_name = Column(String(100), unique=True, index=True, comment="角色名")
    authority = Column(String(225), comment="权限")
    remark = Column(Text, comment="备注")
    create_time = Column(DateTime, comment="创建时间")
